/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import org.apache.nifi.web.security.token.NewAccountAuthorizationRequestToken;
import org.apache.nifi.web.security.token.NewAccountAuthorizationToken;
import org.apache.nifi.web.security.token.NiFiAuthorizationToken;
import org.apache.nifi.web.security.token.NiFiAuthortizationRequestToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class NiFiAuthenticationProvider
implements AuthenticationProvider {
    private final AuthenticationUserDetailsService<NiFiAuthortizationRequestToken> userDetailsService;

    public NiFiAuthenticationProvider(AuthenticationUserDetailsService<NiFiAuthortizationRequestToken> userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        NiFiAuthortizationRequestToken request = (NiFiAuthortizationRequestToken)authentication;
        try {
            UserDetails userDetails = this.userDetailsService.loadUserDetails((Authentication)request);
            NiFiAuthorizationToken result = new NiFiAuthorizationToken(userDetails);
            result.setDetails(request.getDetails());
            return result;
        }
        catch (UsernameNotFoundException unfe) {
            if (this.isNewAccountAuthenticationToken((Authentication)request)) {
                return new NewAccountAuthorizationToken(((NewAccountAuthorizationRequestToken)authentication).getNewAccountRequest());
            }
            throw unfe;
        }
    }

    private boolean isNewAccountAuthenticationToken(Authentication authentication) {
        return NewAccountAuthorizationRequestToken.class.isAssignableFrom(authentication.getClass());
    }

    public boolean supports(Class<?> authentication) {
        return NiFiAuthortizationRequestToken.class.isAssignableFrom(authentication);
    }
}

