/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.user.NiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.apache.nifi.web.security.UntrustedProxyException;
import org.apache.nifi.web.security.token.NiFiAuthorizationRequestToken;
import org.apache.nifi.web.security.user.NiFiUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.filter.GenericFilterBean;

public abstract class NiFiAuthenticationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(NiFiAuthenticationFilter.class);
    private AuthenticationManager authenticationManager;
    private NiFiProperties properties;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug("Checking secure context token: " + SecurityContextHolder.getContext().getAuthentication());
        }
        if (this.requiresAuthentication((HttpServletRequest)request)) {
            this.authenticate((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean requiresAuthentication(HttpServletRequest request) {
        if (this.isAnonymousUser()) {
            return true;
        }
        return NiFiUserUtils.getNiFiUser() == null && NiFiUserUtils.getNewAccountRequest() == null;
    }

    private boolean isAnonymousUser() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return user != null && "anonymous".equals(user.getIdentity());
    }

    private void authenticate(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String dnChain = null;
        try {
            NiFiAuthorizationRequestToken authenticated = this.attemptAuthentication(request);
            if (authenticated != null) {
                dnChain = ProxiedEntitiesUtils.formatProxyDn(StringUtils.join(authenticated.getChain(), (String)"><"));
                log.info(String.format("Attempting request for (%s) %s %s (source ip: %s)", dnChain, request.getMethod(), request.getRequestURL().toString(), request.getRemoteAddr()));
                Authentication authorized = this.authenticationManager.authenticate((Authentication)authenticated);
                this.successfulAuthorization(request, response, authorized);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (InvalidAuthenticationException iae) {
            this.unsuccessfulAuthorization(request, response, iae);
        }
        catch (AuthenticationException ae) {
            if (this.isAnonymousUser()) {
                if (dnChain == null) {
                    log.info(String.format("Continuing as anonymous user. Unable to authenticate %s: %s", new Object[]{dnChain, ae}));
                } else {
                    log.info(String.format("Continuing as anonymous user. Unable to authenticate: %s", new Object[]{ae}));
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            this.unsuccessfulAuthorization(request, response, ae);
        }
    }

    public abstract NiFiAuthorizationRequestToken attemptAuthentication(HttpServletRequest var1);

    protected void successfulAuthorization(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        if (log.isDebugEnabled()) {
            log.debug("Authentication success: " + authResult);
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        ProxiedEntitiesUtils.successfulAuthorization(request, response, authResult);
    }

    protected void unsuccessfulAuthorization(HttpServletRequest request, HttpServletResponse response, AuthenticationException ae) throws IOException {
        ProxiedEntitiesUtils.unsuccessfulAuthorization(request, response, ae);
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        if (ae instanceof UsernameNotFoundException) {
            if (this.properties.getSupportNewAccountRequests()) {
                response.setStatus(401);
                out.println("Not authorized.");
            } else {
                response.setStatus(403);
                out.println("Access is denied.");
            }
        } else if (ae instanceof InvalidAuthenticationException) {
            response.setStatus(401);
            out.println(ae.getMessage());
        } else if (ae instanceof AccountStatusException) {
            response.setStatus(403);
            out.println(ae.getMessage());
        } else if (ae instanceof UntrustedProxyException) {
            response.setStatus(403);
            out.println(ae.getMessage());
        } else if (ae instanceof AuthenticationServiceException) {
            log.error(String.format("Unable to authorize: %s", ae.getMessage()), (Throwable)ae);
            response.setStatus(500);
            out.println(String.format("Unable to authorize: %s", ae.getMessage()));
        } else {
            log.error(String.format("Unable to authorize: %s", ae.getMessage()), (Throwable)ae);
            response.setStatus(403);
            out.println("Access is denied.");
        }
        log.info(String.format("Rejecting access to web api: %s", ae.getMessage()));
        if (log.isDebugEnabled()) {
            log.debug("", (Throwable)ae);
        }
    }

    protected final boolean isNewAccountRequest(HttpServletRequest request) {
        String path;
        return "POST".equalsIgnoreCase(request.getMethod()) && StringUtils.isNotBlank((CharSequence)(path = request.getPathInfo())) && "/controller/users".equals(path);
    }

    protected final String getJustification(HttpServletRequest request) {
        String justification = request.getParameter("justification");
        if (justification == null) {
            justification = "";
        }
        return justification;
    }

    public void destroy() {
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

