/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.anonymous;

import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.admin.service.AdministrationException;
import org.apache.nifi.admin.service.UserService;
import org.apache.nifi.authorization.Authority;
import org.apache.nifi.user.NiFiUser;
import org.apache.nifi.web.security.token.NiFiAuthorizationToken;
import org.apache.nifi.web.security.user.NiFiUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

public class NiFiAnonymousUserFilter
extends AnonymousAuthenticationFilter {
    private static final Logger anonymousUserFilterLogger = LoggerFactory.getLogger(NiFiAnonymousUserFilter.class);
    private static final String ANONYMOUS_KEY = "anonymousNifiKey";
    private UserService userService;

    public NiFiAnonymousUserFilter() {
        super(ANONYMOUS_KEY);
    }

    protected Authentication createAuthentication(HttpServletRequest request) {
        NiFiAuthorizationToken authentication;
        block4: {
            authentication = null;
            try {
                NiFiUser user = this.userService.getUserByDn("anonymous");
                if (!request.isSecure()) {
                    user.getAuthorities().addAll(EnumSet.allOf(Authority.class));
                }
                if (!user.getAuthorities().isEmpty() || !request.getContextPath().startsWith("/nifi-api")) {
                    NiFiUserDetails userDetails = new NiFiUserDetails(user);
                    authentication = new NiFiAuthorizationToken(userDetails);
                }
            }
            catch (AdministrationException ase) {
                anonymousUserFilterLogger.warn("Unable to load anonymous user from accounts database: " + ase.getMessage());
                if (!anonymousUserFilterLogger.isDebugEnabled()) break block4;
                anonymousUserFilterLogger.warn("", (Throwable)ase);
            }
        }
        return authentication;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

