/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.user.NiFiUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class ProxiedEntitiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProxiedEntitiesUtils.class);
    public static final String PROXY_ENTITIES_CHAIN = "X-ProxiedEntitiesChain";
    public static final String PROXY_ENTITIES_ACCEPTED = "X-ProxiedEntitiesAccepted";
    public static final String PROXY_ENTITIES_DETAILS = "X-ProxiedEntitiesDetails";
    private static final String GT = ">";
    private static final String ESCAPED_GT = "\\\\>";
    private static final String LT = "<";
    private static final String ESCAPED_LT = "\\\\<";

    public static String formatProxyDn(String dn) {
        return LT + ProxiedEntitiesUtils.sanitizeDn(dn) + GT;
    }

    private static String sanitizeDn(String rawDn) {
        if (StringUtils.isEmpty((CharSequence)rawDn)) {
            return rawDn;
        }
        String sanitizedDn = rawDn.replaceAll(GT, ESCAPED_GT).replaceAll(LT, ESCAPED_LT);
        if (!sanitizedDn.equals(rawDn)) {
            logger.warn("The provided DN [" + rawDn + "] contained dangerous characters that were escaped to [" + sanitizedDn + "]");
        }
        return sanitizedDn;
    }

    private static String unsanitizeDn(String sanitizedDn) {
        if (StringUtils.isEmpty((CharSequence)sanitizedDn)) {
            return sanitizedDn;
        }
        String unsanitizedDn = sanitizedDn.replaceAll(ESCAPED_GT, GT).replaceAll(ESCAPED_LT, LT);
        if (!unsanitizedDn.equals(sanitizedDn)) {
            logger.warn("The provided DN [" + sanitizedDn + "] had been escaped, and was reconstituted to the dangerous DN [" + unsanitizedDn + "]");
        }
        return unsanitizedDn;
    }

    public static List<String> tokenizeProxiedEntitiesChain(String rawProxyChain) {
        ArrayList<String> proxyChain = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)rawProxyChain)) {
            List<String> elements = Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)rawProxyChain, (String)"><"));
            ArrayList<String> unsanitizedElements = new ArrayList<String>(elements.size());
            for (String element : elements) {
                unsanitizedElements.add(ProxiedEntitiesUtils.unsanitizeDn(element));
            }
            unsanitizedElements.set(0, ((String)unsanitizedElements.get(0)).replaceFirst(LT, ""));
            int last = unsanitizedElements.size() - 1;
            String lastElement = (String)unsanitizedElements.get(last);
            if (lastElement.endsWith(GT)) {
                unsanitizedElements.set(last, lastElement.substring(0, lastElement.length() - 1));
            }
            proxyChain.addAll(unsanitizedElements);
        }
        return proxyChain;
    }

    public static List<String> buildProxiedEntitiesChain(NiFiUser user) {
        ArrayList<String> proxyChain = new ArrayList<String>();
        for (NiFiUser chainedUser = user; chainedUser != null; chainedUser = chainedUser.getChain()) {
            proxyChain.add(chainedUser.getIdentity());
        }
        return proxyChain;
    }

    public static List<String> buildProxiedEntitiesChain(HttpServletRequest request, String username) {
        ArrayList<String> proxyChain = new ArrayList<String>(ProxiedEntitiesUtils.tokenizeProxiedEntitiesChain(request.getHeader(PROXY_ENTITIES_CHAIN)));
        proxyChain.add(username);
        return proxyChain;
    }

    public static void successfulAuthorization(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(PROXY_ENTITIES_CHAIN))) {
            response.setHeader(PROXY_ENTITIES_ACCEPTED, Boolean.TRUE.toString());
        }
    }

    public static void unsuccessfulAuthorization(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(PROXY_ENTITIES_CHAIN))) {
            response.setHeader(PROXY_ENTITIES_DETAILS, failed.getMessage());
        }
    }
}

