/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.spring;

import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.kerberos.AlternateKerberosUserDetailsService;
import org.apache.nifi.web.security.kerberos.KerberosService;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.kerberos.authentication.KerberosServiceAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosTicketValidator;

public class KerberosServiceFactoryBean
implements FactoryBean<KerberosService> {
    private KerberosService kerberosService = null;
    private NiFiProperties properties = null;

    public KerberosService getObject() throws Exception {
        if (this.kerberosService == null && this.properties.isKerberosServiceSupportEnabled()) {
            this.kerberosService = new KerberosService();
            this.kerberosService.setKerberosServiceAuthenticationProvider(this.createKerberosServiceAuthenticationProvider());
        }
        return this.kerberosService;
    }

    public Class<?> getObjectType() {
        return KerberosService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    private KerberosServiceAuthenticationProvider createKerberosServiceAuthenticationProvider() throws Exception {
        KerberosServiceAuthenticationProvider kerberosServiceAuthenticationProvider = new KerberosServiceAuthenticationProvider();
        kerberosServiceAuthenticationProvider.setTicketValidator(this.createTicketValidator());
        kerberosServiceAuthenticationProvider.setUserDetailsService((UserDetailsService)this.createAlternateKerberosUserDetailsService());
        kerberosServiceAuthenticationProvider.afterPropertiesSet();
        return kerberosServiceAuthenticationProvider;
    }

    private AlternateKerberosUserDetailsService createAlternateKerberosUserDetailsService() {
        return new AlternateKerberosUserDetailsService();
    }

    private KerberosTicketValidator createTicketValidator() throws Exception {
        SunJaasKerberosTicketValidator ticketValidator = new SunJaasKerberosTicketValidator();
        ticketValidator.setServicePrincipal(this.properties.getKerberosServicePrincipal());
        ticketValidator.setKeyTabLocation((Resource)new FileSystemResource(this.properties.getKerberosKeytabLocation()));
        ticketValidator.afterPropertiesSet();
        return ticketValidator;
    }
}

