/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class ProxiedEntitiesUtils {
    public static final String PROXY_ENTITIES_CHAIN = "X-ProxiedEntitiesChain";
    public static final String PROXY_ENTITIES_ACCEPTED = "X-ProxiedEntitiesAccepted";
    public static final String PROXY_ENTITIES_DETAILS = "X-ProxiedEntitiesDetails";
    private static final Pattern proxyChainPattern = Pattern.compile("<(.*?)>");

    public static String formatProxyDn(String dn) {
        return "<" + dn + ">";
    }

    public static List<String> tokenizeProxiedEntitiesChain(String rawProxyChain) {
        ArrayList<String> proxyChain = new ArrayList<String>();
        Matcher rawProxyChainMatcher = proxyChainPattern.matcher(rawProxyChain);
        while (rawProxyChainMatcher.find()) {
            proxyChain.add(rawProxyChainMatcher.group(1));
        }
        return proxyChain;
    }

    public static String buildProxiedEntitiesChainString(NiFiUser user) {
        List proxyChain = NiFiUserUtils.buildProxiedEntitiesChain((NiFiUser)user);
        return ProxiedEntitiesUtils.formatProxyDn(StringUtils.join((Iterable)proxyChain, (String)"><"));
    }

    public static List<String> buildProxiedEntitiesChain(HttpServletRequest request, String username) {
        String chain = ProxiedEntitiesUtils.buildProxiedEntitiesChainString(request, username);
        return ProxiedEntitiesUtils.tokenizeProxiedEntitiesChain(chain);
    }

    public static String buildProxiedEntitiesChainString(HttpServletRequest request, String username) {
        String principal = username.startsWith("<") && username.endsWith(">") ? username : ProxiedEntitiesUtils.formatProxyDn(username);
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(PROXY_ENTITIES_CHAIN))) {
            principal = request.getHeader(PROXY_ENTITIES_CHAIN) + principal;
        }
        return principal;
    }

    public static void successfulAuthorization(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(PROXY_ENTITIES_CHAIN))) {
            response.setHeader(PROXY_ENTITIES_ACCEPTED, Boolean.TRUE.toString());
        }
    }

    public static void unsuccessfulAuthorization(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(PROXY_ENTITIES_CHAIN))) {
            response.setHeader(PROXY_ENTITIES_DETAILS, failed.getMessage());
        }
    }
}

