/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import java.util.Collections;
import java.util.List;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;

public abstract class NiFiAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NiFiAuthenticationProvider.class);
    private NiFiProperties properties;
    private List<IdentityMapping> mappings;

    public NiFiAuthenticationProvider(NiFiProperties properties) {
        this.properties = properties;
        this.mappings = Collections.unmodifiableList(IdentityMappingUtil.getIdentityMappings((NiFiProperties)properties));
    }

    public List<IdentityMapping> getMappings() {
        return this.mappings;
    }

    protected String mapIdentity(String identity) {
        return IdentityMappingUtil.mapIdentity((String)identity, this.mappings);
    }
}

