/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.State;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.web.security.oidc.OidcIdentityProvider;
import org.apache.nifi.web.security.util.CacheKey;

public class OidcService {
    private OidcIdentityProvider identityProvider;
    private Cache<CacheKey, State> stateLookupForPendingRequests;
    private Cache<CacheKey, String> jwtLookupForCompletedRequests;

    public OidcService(OidcIdentityProvider identityProvider) {
        this(identityProvider, 60, TimeUnit.SECONDS);
    }

    public OidcService(OidcIdentityProvider identityProvider, int duration, TimeUnit units) {
        if (identityProvider == null) {
            throw new RuntimeException("The OidcIdentityProvider must be specified.");
        }
        this.identityProvider = identityProvider;
        this.stateLookupForPendingRequests = CacheBuilder.newBuilder().expireAfterWrite((long)duration, units).build();
        this.jwtLookupForCompletedRequests = CacheBuilder.newBuilder().expireAfterWrite((long)duration, units).build();
    }

    public boolean isOidcEnabled() {
        return this.identityProvider.isOidcEnabled();
    }

    public URI getAuthorizationEndpoint() {
        return this.identityProvider.getAuthorizationEndpoint();
    }

    public URI getEndSessionEndpoint() {
        return this.identityProvider.getEndSessionEndpoint();
    }

    public Scope getScope() {
        return this.identityProvider.getScope();
    }

    public String getClientId() {
        return this.identityProvider.getClientId().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State createState(String oidcRequestIdentifier) {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        CacheKey oidcRequestIdentifierKey = new CacheKey(oidcRequestIdentifier);
        State state = new State(this.generateStateValue());
        try {
            Cache<CacheKey, State> cache = this.stateLookupForPendingRequests;
            synchronized (cache) {
                State cachedState = (State)this.stateLookupForPendingRequests.get((Object)oidcRequestIdentifierKey, () -> state);
                if (!this.timeConstantEqualityCheck(state.getValue(), cachedState.getValue())) {
                    throw new IllegalStateException("An existing login request is already in progress.");
                }
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Unable to store the login request state.");
        }
        return state;
    }

    private String generateStateValue() {
        return new BigInteger(130, new SecureRandom()).toString(32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStateValid(String oidcRequestIdentifier, State proposedState) {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        if (proposedState == null) {
            throw new IllegalArgumentException("Proposed state must be specified.");
        }
        CacheKey oidcRequestIdentifierKey = new CacheKey(oidcRequestIdentifier);
        Cache<CacheKey, State> cache = this.stateLookupForPendingRequests;
        synchronized (cache) {
            State state = (State)this.stateLookupForPendingRequests.getIfPresent((Object)oidcRequestIdentifierKey);
            if (state != null) {
                this.stateLookupForPendingRequests.invalidate((Object)oidcRequestIdentifierKey);
            }
            return state != null && this.timeConstantEqualityCheck(state.getValue(), proposedState.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeAuthorizationCode(String oidcRequestIdentifier, AuthorizationGrant authorizationGrant) throws IOException {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        CacheKey oidcRequestIdentifierKey = new CacheKey(oidcRequestIdentifier);
        String nifiJwt = this.identityProvider.exchangeAuthorizationCode(authorizationGrant);
        try {
            Cache<CacheKey, String> cache = this.jwtLookupForCompletedRequests;
            synchronized (cache) {
                String cachedJwt = (String)this.jwtLookupForCompletedRequests.get((Object)oidcRequestIdentifierKey, () -> nifiJwt);
                if (!this.timeConstantEqualityCheck(nifiJwt, cachedJwt)) {
                    throw new IllegalStateException("An existing login request is already in progress.");
                }
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Unable to store the login authentication token.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJwt(String oidcRequestIdentifier) {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        CacheKey oidcRequestIdentifierKey = new CacheKey(oidcRequestIdentifier);
        Cache<CacheKey, String> cache = this.jwtLookupForCompletedRequests;
        synchronized (cache) {
            String jwt = (String)this.jwtLookupForCompletedRequests.getIfPresent((Object)oidcRequestIdentifierKey);
            if (jwt != null) {
                this.jwtLookupForCompletedRequests.invalidate((Object)oidcRequestIdentifierKey);
            }
            return jwt;
        }
    }

    private boolean timeConstantEqualityCheck(String value1, String value2) {
        if (value1 == null || value2 == null) {
            return false;
        }
        return MessageDigest.isEqual(value1.getBytes(StandardCharsets.UTF_8), value2.getBytes(StandardCharsets.UTF_8));
    }
}

