/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.otp;

import com.google.common.cache.AbstractCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.web.security.util.CacheKey;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCache
extends AbstractCache<CacheKey, String> {
    private static final Logger logger = LoggerFactory.getLogger(TokenCache.class);
    private final String contentsDescription;
    private final Cache<CacheKey, String> internalCache;

    public TokenCache(String contentsDescription, int duration, TimeUnit units) {
        this.contentsDescription = contentsDescription;
        this.internalCache = CacheBuilder.newBuilder().expireAfterWrite((long)duration, units).build();
    }

    public @Nullable String getIfPresent(Object key) {
        return (String)this.internalCache.getIfPresent(key);
    }

    public void put(CacheKey key, String value) {
        this.internalCache.put((Object)key, (Object)value);
    }

    public boolean containsValue(String value) {
        return this.internalCache.asMap().containsValue(value);
    }

    public @Nullable CacheKey getKeyForValue(String value) {
        if (this.containsValue(value)) {
            ConcurrentMap cacheMap = this.internalCache.asMap();
            for (Map.Entry e : cacheMap.entrySet()) {
                if (!((String)e.getValue()).equals(value)) continue;
                return (CacheKey)e.getKey();
            }
            throw new IllegalStateException("The value existed in the cache but expired during retrieval");
        }
        return null;
    }

    public void invalidate(Object key) {
        this.internalCache.invalidate(key);
    }

    public void invalidateAll() {
        this.internalCache.invalidateAll(this.internalCache.asMap().keySet());
    }

    public long size() {
        return this.internalCache.size();
    }

    public CacheStats stats() {
        return this.internalCache.stats();
    }

    public ConcurrentMap<CacheKey, String> asMap() {
        return this.internalCache.asMap();
    }

    public String toString() {
        return "TokenCache for " + this.contentsDescription + " with " + this.internalCache.size() + " elements";
    }
}

