/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.otp;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.nifi.web.security.otp.OtpAuthenticationException;
import org.apache.nifi.web.security.otp.TokenCache;
import org.apache.nifi.web.security.token.OtpAuthenticationToken;
import org.apache.nifi.web.security.util.CacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpService {
    private static final Logger logger = LoggerFactory.getLogger(OtpService.class);
    private static final String HMAC_SHA256 = "HmacSHA256";
    protected static final int MAX_CACHE_SOFT_LIMIT = 100;
    private final TokenCache downloadTokens;
    private final TokenCache uiExtensionTokens;

    public OtpService() {
        this(5, TimeUnit.MINUTES);
    }

    public OtpService(int duration, TimeUnit units) {
        this.downloadTokens = new TokenCache("download tokens", duration, units);
        this.uiExtensionTokens = new TokenCache("UI extension tokens", duration, units);
    }

    public String generateDownloadToken(OtpAuthenticationToken authenticationToken) {
        return this.generateToken(this.downloadTokens, authenticationToken);
    }

    public String getAuthenticationFromDownloadToken(String token) throws OtpAuthenticationException {
        return this.getAuthenticationFromToken(this.downloadTokens, token);
    }

    public String generateUiExtensionToken(OtpAuthenticationToken authenticationToken) {
        return this.generateToken(this.uiExtensionTokens, authenticationToken);
    }

    public String getAuthenticationFromUiExtensionToken(String token) throws OtpAuthenticationException {
        return this.getAuthenticationFromToken(this.uiExtensionTokens, token);
    }

    private String generateToken(TokenCache tokenCache, OtpAuthenticationToken authenticationToken) {
        String userId = (String)authenticationToken.getPrincipal();
        if (tokenCache.containsValue(userId)) {
            return tokenCache.getKeyForValue(userId).getKey();
        }
        if (tokenCache.size() >= 100L) {
            throw new IllegalStateException("The maximum number of single use tokens have been issued.");
        }
        CacheKey cacheKey = new CacheKey(this.hash(authenticationToken));
        tokenCache.put(cacheKey, userId);
        return cacheKey.getKey();
    }

    private String getAuthenticationFromToken(TokenCache tokenCache, String token) throws OtpAuthenticationException {
        CacheKey cacheKey = new CacheKey(token);
        String authenticatedUser = tokenCache.getIfPresent(cacheKey);
        if (authenticatedUser == null) {
            throw new OtpAuthenticationException("Unable to validate the access token.");
        }
        tokenCache.invalidate(cacheKey);
        return authenticatedUser;
    }

    private String hash(OtpAuthenticationToken authenticationToken) {
        try {
            String input = authenticationToken.getName() + "-" + System.nanoTime();
            SecureRandom secureRandom = new SecureRandom();
            byte[] randomBytes = new byte[32];
            secureRandom.nextBytes(randomBytes);
            SecretKeySpec secret = new SecretKeySpec(randomBytes, HMAC_SHA256);
            Mac hmacSha256 = Mac.getInstance(HMAC_SHA256);
            hmacSha256.init(secret);
            byte[] output = hmacSha256.doFinal(input.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64URLSafeString((byte[])output);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            String errorMessage = "There was an error generating the OTP";
            logger.error("There was an error generating the OTP", (Throwable)e);
            throw new IllegalStateException("Unable to generate single use token.");
        }
    }
}

