/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationFilter;
import org.apache.nifi.web.security.jwt.JwtAuthenticationRequestToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class JwtAuthenticationFilter
extends NiFiAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(JwtAuthenticationFilter.class);
    public static final String AUTHORIZATION = "Authorization";
    private static final Pattern tokenPattern = Pattern.compile("^Bearer (\\S*\\.\\S*\\.\\S*)$");

    @Override
    public Authentication attemptAuthentication(HttpServletRequest request) {
        if (!request.isSecure()) {
            return null;
        }
        String authorizationHeader = request.getHeader(AUTHORIZATION);
        if (authorizationHeader == null || !this.validJwtFormat(authorizationHeader)) {
            return null;
        }
        String token = JwtAuthenticationFilter.getTokenFromHeader(authorizationHeader);
        return new JwtAuthenticationRequestToken(token, request.getRemoteAddr());
    }

    private boolean validJwtFormat(String authenticationHeader) {
        Matcher matcher = tokenPattern.matcher(authenticationHeader);
        return matcher.matches();
    }

    public static String getTokenFromHeader(String authenticationHeader) {
        Matcher matcher = tokenPattern.matcher(authenticationHeader);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new InvalidAuthenticationException("JWT did not match expected pattern.");
    }
}

