/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.security.saml.NiFiSAMLContextProvider;
import org.apache.nifi.web.security.saml.SAMLConfiguration;
import org.apache.nifi.web.security.saml.SAMLConfigurationFactory;
import org.apache.nifi.web.security.saml.SAMLService;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLRuntimeException;
import org.opensaml.common.binding.decoding.URIComparator;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.SAMLLogoutProcessingFilter;
import org.springframework.security.saml.SAMLProcessingFilter;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.log.SAMLLogger;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.metadata.MetadataMemoryProvider;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.util.DefaultURLComparator;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.security.saml.websso.SingleLogoutProfile;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.security.saml.websso.WebSSOProfileOptions;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class StandardSAMLService
implements SAMLService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardSAMLService.class);
    private final NiFiProperties properties;
    private final SAMLConfigurationFactory samlConfigurationFactory;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean spMetadataInitialized = new AtomicBoolean(false);
    private final AtomicReference<String> spBaseUrl = new AtomicReference<Object>(null);
    private final URIComparator uriComparator = new DefaultURLComparator();
    private SAMLConfiguration samlConfiguration;

    public StandardSAMLService(SAMLConfigurationFactory samlConfigurationFactory, NiFiProperties properties) {
        this.properties = properties;
        this.samlConfigurationFactory = samlConfigurationFactory;
    }

    @Override
    public synchronized void initialize() {
        if (!this.properties.isSamlEnabled()) {
            return;
        }
        if (this.initialized.get()) {
            return;
        }
        try {
            LOGGER.info("Initializing SAML Service...");
            this.samlConfiguration = this.samlConfigurationFactory.create(this.properties);
            this.initialized.set(true);
            LOGGER.info("Finished initializing SAML Service");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize SAML configuration due to: " + e.getMessage(), e);
        }
    }

    @Override
    public void shutdown() {
        if (!this.properties.isSamlEnabled()) {
            return;
        }
        LOGGER.info("Shutting down SAML Service...");
        if (this.samlConfiguration != null) {
            try {
                Timer backgroundTimer = this.samlConfiguration.getBackgroundTaskTimer();
                backgroundTimer.purge();
                backgroundTimer.cancel();
            }
            catch (Exception e) {
                LOGGER.warn("Error shutting down background timer: " + e.getMessage(), (Throwable)e);
            }
            try {
                MetadataManager metadataManager = this.samlConfiguration.getMetadataManager();
                metadataManager.destroy();
            }
            catch (Exception e) {
                LOGGER.warn("Error shutting down metadata manager: " + e.getMessage(), (Throwable)e);
            }
        }
        this.samlConfiguration = null;
        this.initialized.set(false);
        this.spMetadataInitialized.set(false);
        this.spBaseUrl.set(null);
        LOGGER.info("Finished shutting down SAML Service");
    }

    @Override
    public boolean isSamlEnabled() {
        return this.properties.isSamlEnabled();
    }

    @Override
    public boolean isServiceProviderInitialized() {
        return this.spMetadataInitialized.get();
    }

    @Override
    public synchronized void initializeServiceProvider(String baseUrl) {
        if (!this.isSamlEnabled()) {
            throw new IllegalStateException("SAML support is not configured");
        }
        if (StringUtils.isBlank((String)baseUrl)) {
            throw new IllegalArgumentException("baseUrl is required when initializing the service provider");
        }
        if (this.isServiceProviderInitialized()) {
            String existingBaseUrl = this.spBaseUrl.get();
            LOGGER.info("Service provider already initialized with baseUrl = '{}'", new Object[]{existingBaseUrl});
            return;
        }
        LOGGER.info("Initializing SAML service provider with baseUrl = '{}'", new Object[]{baseUrl});
        try {
            this.initializeServiceProviderMetadata(baseUrl);
            this.spBaseUrl.set(baseUrl);
            this.spMetadataInitialized.set(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize SAML service provider: " + e.getMessage(), e);
        }
        LOGGER.info("Done initializing SAML service provider");
    }

    @Override
    public String getServiceProviderMetadata() {
        this.verifyReadyForSamlOperations();
        try {
            KeyManager keyManager = this.samlConfiguration.getKeyManager();
            MetadataManager metadataManager = this.samlConfiguration.getMetadataManager();
            String spEntityId = this.samlConfiguration.getSpEntityId();
            EntityDescriptor descriptor = metadataManager.getEntityDescriptor(spEntityId);
            String metadataString = SAMLUtil.getMetadataAsString((MetadataManager)metadataManager, (KeyManager)keyManager, (EntityDescriptor)descriptor, null);
            return metadataString;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain SAML service provider metadata", e);
        }
    }

    @Override
    public long getAuthExpiration() {
        this.verifyReadyForSamlOperations();
        return this.samlConfiguration.getAuthExpiration();
    }

    @Override
    public void initiateLogin(HttpServletRequest request, HttpServletResponse response, String relayState) {
        SAMLMessageContext context;
        this.verifyReadyForSamlOperations();
        SAMLLogger samlLogger = this.samlConfiguration.getLogger();
        NiFiSAMLContextProvider contextProvider = this.samlConfiguration.getContextProvider();
        try {
            context = contextProvider.getLocalAndPeerEntity(request, response, Collections.emptyMap());
        }
        catch (MetadataProviderException e) {
            throw new IllegalStateException("Unable to create SAML Message Context: " + e.getMessage(), e);
        }
        WebSSOProfileOptions options = this.samlConfiguration.getWebSSOProfileOptions().clone();
        options.setRelayState(relayState);
        WebSSOProfile webSSOProfile = this.samlConfiguration.getWebSSOProfile();
        try {
            webSSOProfile.sendAuthenticationRequest(context, options);
            samlLogger.log("AuthNRequest", "SUCCESS", context);
        }
        catch (Exception e) {
            samlLogger.log("AuthNRequest", "FAILURE", context);
            throw new RuntimeException("Unable to initiate SAML authentication request: " + e.getMessage(), e);
        }
    }

    @Override
    public SAMLCredential processLogin(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters) {
        SAMLMessageContext context;
        this.verifyReadyForSamlOperations();
        LOGGER.info("Attempting SAML2 authentication using profile {}", (Object)"urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser");
        try {
            NiFiSAMLContextProvider contextProvider = this.samlConfiguration.getContextProvider();
            context = contextProvider.getLocalEntity(request, response, parameters);
        }
        catch (MetadataProviderException e) {
            throw new IllegalStateException("Unable to create SAML Message Context: " + e.getMessage(), e);
        }
        SAMLProcessor samlProcessor = this.samlConfiguration.getProcessor();
        try {
            samlProcessor.retrieveMessage(context);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load SAML message: " + e.getMessage(), e);
        }
        context.setCommunicationProfileId("urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser");
        try {
            context.setLocalEntityEndpoint(this.getLocalEntityEndpoint(context));
        }
        catch (SAMLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (!"urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser".equals(context.getCommunicationProfileId())) {
            throw new IllegalStateException("Unsupported profile encountered in the context: " + context.getCommunicationProfileId());
        }
        SAMLLogger samlLogger = this.samlConfiguration.getLogger();
        WebSSOProfileConsumer webSSOProfileConsumer = this.samlConfiguration.getWebSSOProfileConsumer();
        try {
            SAMLCredential credential = webSSOProfileConsumer.processAuthenticationResponse(context);
            LOGGER.debug("SAML Response contains successful authentication for NameID: " + credential.getNameID().getValue());
            samlLogger.log("AuthNResponse", "SUCCESS", context);
            return credential;
        }
        catch (SAMLException | SAMLRuntimeException e) {
            LOGGER.error("Error validating SAML message", e);
            samlLogger.log("AuthNResponse", "FAILURE", context, (Exception)e);
            throw new RuntimeException("Error validating SAML message: " + e.getMessage(), e);
        }
        catch (SecurityException | ValidationException e) {
            LOGGER.error("Error validating signature", e);
            samlLogger.log("AuthNResponse", "FAILURE", context, (Exception)e);
            throw new RuntimeException("Error validating SAML message signature: " + e.getMessage(), e);
        }
        catch (DecryptionException e) {
            LOGGER.error("Error decrypting SAML message", (Throwable)e);
            samlLogger.log("AuthNResponse", "FAILURE", context, (Exception)((Object)e));
            throw new RuntimeException("Error decrypting SAML message: " + e.getMessage(), e);
        }
    }

    @Override
    public String getUserIdentity(SAMLCredential credential) {
        this.verifyReadyForSamlOperations();
        if (credential == null) {
            throw new IllegalArgumentException("SAML Credential is required");
        }
        String userIdentity = null;
        String identityAttributeName = this.samlConfiguration.getIdentityAttributeName();
        if (StringUtils.isBlank((String)identityAttributeName)) {
            userIdentity = credential.getNameID().getValue();
            LOGGER.info("No identity attribute specified, using NameID for user identity: {}", (Object)userIdentity);
        } else {
            LOGGER.debug("Looking for SAML attribute {} ...", (Object)identityAttributeName);
            List attributes = credential.getAttributes();
            if (attributes == null || attributes.isEmpty()) {
                userIdentity = credential.getNameID().getValue();
                LOGGER.warn("No attributes returned in SAML response, using NameID for user identity: {}", (Object)userIdentity);
            } else {
                for (Attribute attribute : attributes) {
                    if (!identityAttributeName.equals(attribute.getName())) {
                        LOGGER.trace("Skipping SAML attribute {}", (Object)attribute.getName());
                        continue;
                    }
                    for (XMLObject value : attribute.getAttributeValues()) {
                        if (value instanceof XSString) {
                            XSString valueXSString = (XSString)value;
                            userIdentity = valueXSString.getValue();
                            break;
                        }
                        LOGGER.debug("Value was not XSString, but was " + value.getClass().getCanonicalName());
                    }
                    if (userIdentity == null) continue;
                    LOGGER.info("Found user identity {} in attribute {}", (Object)userIdentity, (Object)attribute.getName());
                    break;
                }
            }
            if (userIdentity == null) {
                userIdentity = credential.getNameID().getValue();
                LOGGER.warn("No attribute found named {}, using NameID for user identity: {}", (Object)identityAttributeName, (Object)userIdentity);
            }
        }
        return userIdentity;
    }

    @Override
    public Set<String> getUserGroups(SAMLCredential credential) {
        this.verifyReadyForSamlOperations();
        if (credential == null) {
            throw new IllegalArgumentException("SAML Credential is required");
        }
        String userIdentity = credential.getNameID().getValue();
        String groupAttributeName = this.samlConfiguration.getGroupAttributeName();
        if (StringUtils.isBlank((String)groupAttributeName)) {
            LOGGER.warn("Cannot obtain groups for {} because no group attribute name has been configured", (Object)userIdentity);
            return Collections.emptySet();
        }
        HashSet<String> groups = new HashSet<String>();
        if (credential.getAttributes() != null) {
            for (Attribute attribute : credential.getAttributes()) {
                if (!groupAttributeName.equals(attribute.getName())) {
                    LOGGER.debug("Skipping SAML attribute {}", (Object)attribute.getName());
                    continue;
                }
                for (XMLObject value : attribute.getAttributeValues()) {
                    if (value instanceof XSString) {
                        XSString valueXSString = (XSString)value;
                        String groupName = valueXSString.getValue();
                        LOGGER.debug("Found group {} for {}", (Object)groupName, (Object)userIdentity);
                        groups.add(groupName);
                        continue;
                    }
                    LOGGER.debug("Value was not XSString, but was " + value.getClass().getCanonicalName());
                }
            }
        }
        return groups;
    }

    @Override
    public void initiateLogout(HttpServletRequest request, HttpServletResponse response, SAMLCredential credential) {
        SAMLMessageContext context;
        this.verifyReadyForSamlOperations();
        try {
            NiFiSAMLContextProvider contextProvider = this.samlConfiguration.getContextProvider();
            context = contextProvider.getLocalAndPeerEntity(request, response, Collections.emptyMap());
        }
        catch (MetadataProviderException e) {
            throw new IllegalStateException("Unable to create SAML Message Context: " + e.getMessage(), e);
        }
        SAMLLogger samlLogger = this.samlConfiguration.getLogger();
        SingleLogoutProfile singleLogoutProfile = this.samlConfiguration.getSingleLogoutProfile();
        try {
            singleLogoutProfile.sendLogoutRequest(context, credential);
            samlLogger.log("LogoutRequest", "SUCCESS", context);
        }
        catch (Exception e) {
            samlLogger.log("LogoutRequest", "FAILURE", context);
            throw new RuntimeException("Unable to initiate SAML logout request: " + e.getMessage(), e);
        }
    }

    @Override
    public void processLogout(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters) {
        SAMLMessageContext context;
        this.verifyReadyForSamlOperations();
        try {
            NiFiSAMLContextProvider contextProvider = this.samlConfiguration.getContextProvider();
            context = contextProvider.getLocalAndPeerEntity(request, response, parameters);
        }
        catch (MetadataProviderException e) {
            throw new IllegalStateException("Unable to create SAML Message Context: " + e.getMessage(), e);
        }
        SAMLProcessor samlProcessor = this.samlConfiguration.getProcessor();
        try {
            samlProcessor.retrieveMessage(context);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load SAML message: " + e.getMessage(), e);
        }
        context.setCommunicationProfileId("urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout");
        try {
            context.setLocalEntityEndpoint(this.getLocalEntityEndpoint(context));
        }
        catch (SAMLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (context.getInboundSAMLMessage() instanceof LogoutResponse) {
            this.processLogoutResponse(context);
        } else if (context.getInboundSAMLMessage() instanceof LogoutRequest) {
            this.processLogoutRequest(context);
        }
    }

    private void processLogoutResponse(SAMLMessageContext context) {
        SAMLLogger samlLogger = this.samlConfiguration.getLogger();
        SingleLogoutProfile logoutProfile = this.samlConfiguration.getSingleLogoutProfile();
        try {
            logoutProfile.processLogoutResponse(context);
            samlLogger.log("LogoutResponse", "SUCCESS", context);
        }
        catch (Exception e) {
            LOGGER.error("Received logout response is invalid", (Throwable)e);
            samlLogger.log("LogoutResponse", "FAILURE", context, e);
            throw new RuntimeException("Received logout response is invalid: " + e.getMessage(), e);
        }
    }

    private void processLogoutRequest(SAMLMessageContext context) {
        throw new UnsupportedOperationException("Apache NiFi currently does not support IDP initiated logout");
    }

    private Endpoint getLocalEntityEndpoint(SAMLMessageContext context) throws SAMLException {
        return SAMLUtil.getEndpoint((List)context.getLocalEntityRoleMetadata().getEndpoints(), (String)context.getInboundSAMLBinding(), (InTransport)context.getInboundMessageTransport(), (URIComparator)this.uriComparator);
    }

    private void initializeServiceProviderMetadata(String baseUrl) throws MetadataProviderException {
        SAMLProcessingFilter ssoProcessingFilter = new SAMLProcessingFilter();
        ssoProcessingFilter.setFilterProcessesUrl("/access/saml/login/consumer");
        LogoutHandler noOpLogoutHandler = (request, response, authentication) -> {};
        SAMLLogoutProcessingFilter sloProcessingFilter = new SAMLLogoutProcessingFilter("/nifi", new LogoutHandler[]{noOpLogoutHandler});
        sloProcessingFilter.setFilterProcessesUrl("/access/saml/single-logout/consumer");
        MetadataGenerator metadataGenerator = new MetadataGenerator();
        metadataGenerator.setEntityId(this.samlConfiguration.getSpEntityId());
        metadataGenerator.setEntityBaseURL(baseUrl);
        metadataGenerator.setExtendedMetadata(this.samlConfiguration.getExtendedMetadata());
        metadataGenerator.setIncludeDiscoveryExtension(false);
        metadataGenerator.setKeyManager(this.samlConfiguration.getKeyManager());
        metadataGenerator.setSamlWebSSOFilter(ssoProcessingFilter);
        metadataGenerator.setSamlLogoutProcessingFilter(sloProcessingFilter);
        metadataGenerator.setRequestSigned(this.samlConfiguration.isRequestSigningEnabled());
        metadataGenerator.setWantAssertionSigned(this.samlConfiguration.isWantAssertionsSigned());
        EntityDescriptor descriptor = metadataGenerator.generateMetadata();
        ExtendedMetadata extendedMetadata = metadataGenerator.generateExtendedMetadata();
        MetadataMemoryProvider memoryProvider = new MetadataMemoryProvider(descriptor);
        memoryProvider.initialize();
        ExtendedMetadataDelegate spMetadataProvider = new ExtendedMetadataDelegate((MetadataProvider)memoryProvider, extendedMetadata);
        MetadataManager metadataManager = this.samlConfiguration.getMetadataManager();
        metadataManager.addMetadataProvider((MetadataProvider)spMetadataProvider);
        metadataManager.setHostedSPName(descriptor.getEntityID());
        metadataManager.refreshMetadata();
    }

    private void verifyReadyForSamlOperations() {
        if (!this.isSamlEnabled()) {
            throw new IllegalStateException("SAML support is not configured");
        }
        if (!this.initialized.get()) {
            throw new IllegalStateException("StandardSAMLService has not been initialized");
        }
        if (!this.isServiceProviderInitialized()) {
            throw new IllegalStateException("Service Provider is not initialized");
        }
    }
}

