/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.knox;

import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.knox.KnoxService;
import org.apache.nifi.web.security.knox.StandardKnoxConfiguration;
import org.springframework.beans.factory.FactoryBean;

public class KnoxServiceFactoryBean
implements FactoryBean<KnoxService> {
    private KnoxService knoxService = null;
    private NiFiProperties properties = null;

    public KnoxService getObject() throws Exception {
        if (this.knoxService == null) {
            if (this.properties.isKnoxSsoEnabled() && (this.properties.isLoginIdentityProviderEnabled() || this.properties.isOidcEnabled() || this.properties.isSamlEnabled())) {
                throw new RuntimeException("Apache Knox SSO support cannot be enabled if the Login Identity Provider or OpenId Connect or SAML is configured.");
            }
            StandardKnoxConfiguration configuration = new StandardKnoxConfiguration(this.properties);
            this.knoxService = new KnoxService(configuration);
        }
        return this.knoxService;
    }

    public Class<?> getObjectType() {
        return KnoxService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

