/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.saml.NiFiSAMLContextProvider;
import org.apache.nifi.web.security.saml.impl.http.HttpServletRequestWithParameters;
import org.apache.nifi.web.security.saml.impl.http.ProxyAwareHttpServletRequestWrapper;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.context.SAMLContextProviderImpl;
import org.springframework.security.saml.context.SAMLMessageContext;

public class NiFiSAMLContextProviderImpl
extends SAMLContextProviderImpl
implements NiFiSAMLContextProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NiFiSAMLContextProviderImpl.class);

    @Override
    public SAMLMessageContext getLocalEntity(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters) throws MetadataProviderException {
        SAMLMessageContext context = new SAMLMessageContext();
        this.populateGenericContext(request, response, parameters, context);
        this.populateLocalEntityId(context, request.getRequestURI());
        this.populateLocalContext(context);
        return context;
    }

    @Override
    public SAMLMessageContext getLocalAndPeerEntity(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters) throws MetadataProviderException {
        SAMLMessageContext context = new SAMLMessageContext();
        this.populateGenericContext(request, response, parameters, context);
        this.populateLocalEntityId(context, request.getRequestURI());
        this.populateLocalContext(context);
        this.populatePeerEntityId(context);
        this.populatePeerContext(context);
        return context;
    }

    protected void populateGenericContext(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters, SAMLMessageContext context) {
        ProxyAwareHttpServletRequestWrapper requestWrapper = new ProxyAwareHttpServletRequestWrapper(request);
        LOGGER.debug("Populating SAMLContext - request wrapper URL is [{}]", (Object)requestWrapper.getRequestURL().toString());
        HttpServletRequestWithParameters inTransport = new HttpServletRequestWithParameters((HttpServletRequest)requestWrapper, parameters);
        HttpServletResponseAdapter outTransport = new HttpServletResponseAdapter(response, requestWrapper.isSecure());
        requestWrapper.setAttribute("localContextPath", requestWrapper.getContextPath());
        context.setMetadataProvider((MetadataProvider)this.metadata);
        context.setInboundMessageTransport((InTransport)inTransport);
        context.setOutboundMessageTransport((OutTransport)outTransport);
        context.setMessageStorage(this.storageFactory.getMessageStorage((HttpServletRequest)requestWrapper));
    }
}

