/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt;

import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.security.NiFiAuthenticationFilter;
import org.apache.nifi.web.security.jwt.JwtAuthenticationRequestToken;
import org.apache.nifi.web.security.jwt.NiFiBearerTokenResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class JwtAuthenticationFilter
extends NiFiAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(JwtAuthenticationFilter.class);
    private static NiFiBearerTokenResolver bearerTokenResolver = new NiFiBearerTokenResolver();

    @Override
    public Authentication attemptAuthentication(HttpServletRequest request) {
        if (!request.isSecure()) {
            return null;
        }
        String headerToken = bearerTokenResolver.resolve(request);
        if (StringUtils.isNotBlank((String)headerToken)) {
            return new JwtAuthenticationRequestToken(headerToken, request.getRemoteAddr());
        }
        return null;
    }
}

