/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt;

import io.jsonwebtoken.JwtException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.admin.service.IdpUserGroupService;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationProvider;
import org.apache.nifi.web.security.jwt.JwtAuthenticationRequestToken;
import org.apache.nifi.web.security.jwt.JwtService;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class JwtAuthenticationProvider
extends NiFiAuthenticationProvider {
    private final JwtService jwtService;
    private final IdpUserGroupService idpUserGroupService;

    public JwtAuthenticationProvider(JwtService jwtService, NiFiProperties nifiProperties, Authorizer authorizer, IdpUserGroupService idpUserGroupService) {
        super(nifiProperties, authorizer);
        this.jwtService = jwtService;
        this.idpUserGroupService = idpUserGroupService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JwtAuthenticationRequestToken request = (JwtAuthenticationRequestToken)authentication;
        try {
            String jwtPrincipal = this.jwtService.getAuthenticationFromToken(request.getToken());
            String mappedIdentity = this.mapIdentity(jwtPrincipal);
            Set<String> userGroupProviderGroups = this.getUserGroups(mappedIdentity);
            Set<String> idpUserGroups = this.getIdpUserGroups(mappedIdentity);
            StandardNiFiUser user = new StandardNiFiUser.Builder().identity(mappedIdentity).groups(userGroupProviderGroups).identityProviderGroups(idpUserGroups).clientAddress(request.getClientAddress()).build();
            return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails((NiFiUser)user));
        }
        catch (JwtException e) {
            throw new InvalidAuthenticationException(e.getMessage(), e);
        }
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthenticationRequestToken.class.isAssignableFrom(authentication);
    }

    private Set<String> getIdpUserGroups(String mappedIdentity) {
        return this.idpUserGroupService.getUserGroups(mappedIdentity).stream().map(ug -> ug.getGroupName()).collect(Collectors.toSet());
    }
}

