/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.jwt.BearerTokenResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

public class NiFiBearerTokenResolver
implements BearerTokenResolver {
    private static final Logger logger = LoggerFactory.getLogger(NiFiBearerTokenResolver.class);
    private static final Pattern BEARER_HEADER_PATTERN = Pattern.compile("^Bearer (\\S*\\.\\S*\\.\\S*){1}$");
    private static final Pattern JWT_PATTERN = Pattern.compile("^(\\S*\\.\\S*\\.\\S*)$");
    public static final String AUTHORIZATION = "Authorization";
    public static final String JWT_COOKIE_NAME = "__Host-Authorization-Bearer";

    @Override
    public String resolve(HttpServletRequest request) {
        String authorizationHeader = request.getHeader(AUTHORIZATION);
        Cookie cookieHeader = WebUtils.getCookie((HttpServletRequest)request, (String)JWT_COOKIE_NAME);
        if (StringUtils.isNotBlank((String)authorizationHeader) && this.validAuthorizationHeaderFormat(authorizationHeader)) {
            return this.getTokenFromHeader(authorizationHeader);
        }
        if (cookieHeader != null && this.validJwtFormat(cookieHeader.getValue())) {
            return cookieHeader.getValue();
        }
        logger.debug("Authorization header was not present or not in a valid format.");
        return null;
    }

    private boolean validAuthorizationHeaderFormat(String authorizationHeader) {
        Matcher matcher = BEARER_HEADER_PATTERN.matcher(authorizationHeader);
        return matcher.matches();
    }

    private boolean validJwtFormat(String jwt) {
        Matcher matcher = JWT_PATTERN.matcher(jwt);
        return matcher.matches();
    }

    private String getTokenFromHeader(String authenticationHeader) {
        Matcher matcher = BEARER_HEADER_PATTERN.matcher(authenticationHeader);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new InvalidAuthenticationException("JWT did not match expected pattern.");
    }
}

