/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.otp;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.admin.service.IdpUserGroupService;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationProvider;
import org.apache.nifi.web.security.otp.OtpAuthenticationException;
import org.apache.nifi.web.security.otp.OtpAuthenticationRequestToken;
import org.apache.nifi.web.security.otp.OtpService;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class OtpAuthenticationProvider
extends NiFiAuthenticationProvider {
    private OtpService otpService;
    private final IdpUserGroupService idpUserGroupService;

    public OtpAuthenticationProvider(OtpService otpService, NiFiProperties nifiProperties, Authorizer authorizer, IdpUserGroupService idpUserGroupService) {
        super(nifiProperties, authorizer);
        this.otpService = otpService;
        this.idpUserGroupService = idpUserGroupService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OtpAuthenticationRequestToken request = (OtpAuthenticationRequestToken)authentication;
        try {
            String otpPrincipal = request.isDownloadToken() ? this.otpService.getAuthenticationFromDownloadToken(request.getToken()) : this.otpService.getAuthenticationFromUiExtensionToken(request.getToken());
            String mappedIdentity = this.mapIdentity(otpPrincipal);
            Set<String> userGroupProviderGroups = this.getUserGroups(mappedIdentity);
            Set<String> idpUserGroups = this.getIdpUserGroups(mappedIdentity);
            StandardNiFiUser user = new StandardNiFiUser.Builder().identity(mappedIdentity).groups(userGroupProviderGroups).identityProviderGroups(idpUserGroups).clientAddress(request.getClientAddress()).build();
            return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails((NiFiUser)user));
        }
        catch (OtpAuthenticationException e) {
            throw new InvalidAuthenticationException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public boolean supports(Class<?> authentication) {
        return OtpAuthenticationRequestToken.class.isAssignableFrom(authentication);
    }

    private Set<String> getIdpUserGroups(String mappedIdentity) {
        return this.idpUserGroupService.getUserGroups(mappedIdentity).stream().map(ug -> ug.getGroupName()).collect(Collectors.toSet());
    }
}

