/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.spring;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authentication.LoginCredentials;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authentication.LoginIdentityProviderConfigurationContext;
import org.apache.nifi.authentication.LoginIdentityProviderInitializationContext;
import org.apache.nifi.authentication.LoginIdentityProviderLookup;
import org.apache.nifi.authentication.annotation.LoginIdentityProviderContext;
import org.apache.nifi.authentication.exception.ProviderCreationException;
import org.apache.nifi.authentication.exception.ProviderDestructionException;
import org.apache.nifi.authentication.generated.LoginIdentityProviders;
import org.apache.nifi.authentication.generated.Property;
import org.apache.nifi.authentication.generated.Provider;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.properties.PropertyProtectionScheme;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProviderFactoryAware;
import org.apache.nifi.security.xml.XmlUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.spring.StandardLoginIdentityProviderConfigurationContext;
import org.apache.nifi.web.security.spring.StandardLoginIdentityProviderInitializationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.xml.sax.SAXException;

public class LoginIdentityProviderFactoryBean
extends SensitivePropertyProviderFactoryAware
implements FactoryBean,
DisposableBean,
LoginIdentityProviderLookup {
    private static final Logger logger = LoggerFactory.getLogger(LoginIdentityProviderFactoryBean.class);
    private static final String LOGIN_IDENTITY_PROVIDERS_XSD = "/login-identity-providers.xsd";
    private static final String JAXB_GENERATED_PATH = "org.apache.nifi.authentication.generated";
    private static final JAXBContext JAXB_CONTEXT = LoginIdentityProviderFactoryBean.initializeJaxbContext();
    private NiFiProperties properties;
    private ExtensionManager extensionManager;
    private LoginIdentityProvider loginIdentityProvider;
    private final Map<String, LoginIdentityProvider> loginIdentityProviders = new HashMap<String, LoginIdentityProvider>();

    private static JAXBContext initializeJaxbContext() {
        try {
            return JAXBContext.newInstance((String)JAXB_GENERATED_PATH, (ClassLoader)LoginIdentityProviderFactoryBean.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.");
        }
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public LoginIdentityProvider getLoginIdentityProvider(String identifier) {
        return this.loginIdentityProviders.get(identifier);
    }

    public Object getObject() throws Exception {
        String loginIdentityProviderIdentifier;
        if (this.loginIdentityProvider == null && StringUtils.isNotBlank((CharSequence)(loginIdentityProviderIdentifier = this.properties.getProperty("nifi.security.user.login.identity.provider")))) {
            LoginIdentityProviders loginIdentityProviderConfiguration = this.loadLoginIdentityProvidersConfiguration();
            for (Provider provider : loginIdentityProviderConfiguration.getProvider()) {
                this.loginIdentityProviders.put(provider.getIdentifier(), this.createLoginIdentityProvider(provider.getIdentifier(), provider.getClazz()));
            }
            for (Provider provider : loginIdentityProviderConfiguration.getProvider()) {
                LoginIdentityProvider instance = this.loginIdentityProviders.get(provider.getIdentifier());
                instance.onConfigured(this.loadLoginIdentityProviderConfiguration(provider));
            }
            this.loginIdentityProvider = this.getLoginIdentityProvider(loginIdentityProviderIdentifier);
            if (this.loginIdentityProvider == null) {
                throw new Exception(String.format("The specified login identity provider '%s' could not be found.", loginIdentityProviderIdentifier));
            }
        }
        return this.loginIdentityProvider;
    }

    private LoginIdentityProviders loadLoginIdentityProvidersConfiguration() throws Exception {
        File loginIdentityProvidersConfigurationFile = this.properties.getLoginIdentityProviderConfigurationFile();
        if (loginIdentityProvidersConfigurationFile.exists()) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(LoginIdentityProviders.class.getResource(LOGIN_IDENTITY_PROVIDERS_XSD));
                XMLStreamReader xsr = XmlUtils.createSafeReader((StreamSource)new StreamSource(loginIdentityProvidersConfigurationFile));
                Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
                unmarshaller.setSchema(schema);
                JAXBElement element = unmarshaller.unmarshal(xsr, LoginIdentityProviders.class);
                return (LoginIdentityProviders)element.getValue();
            }
            catch (JAXBException | SAXException e) {
                throw new Exception("Unable to load the login identity provider configuration file at: " + loginIdentityProvidersConfigurationFile.getAbsolutePath());
            }
        }
        throw new Exception("Unable to find the login identity provider configuration file at " + loginIdentityProvidersConfigurationFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginIdentityProvider createLoginIdentityProvider(String identifier, String loginIdentityProviderClassName) throws Exception {
        LoginIdentityProvider instance;
        List loginIdentityProviderBundles = this.extensionManager.getBundles(loginIdentityProviderClassName);
        if (loginIdentityProviderBundles.size() == 0) {
            throw new Exception(String.format("The specified login identity provider class '%s' is not known to this nifi.", loginIdentityProviderClassName));
        }
        if (loginIdentityProviderBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified login identity provider class '%s', only one is allowed.", loginIdentityProviderClassName));
        }
        Bundle loginIdentityProviderBundle = (Bundle)loginIdentityProviderBundles.get(0);
        ClassLoader loginIdentityProviderClassLoader = loginIdentityProviderBundle.getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loginIdentityProviderClassLoader);
            Class<?> rawLoginIdentityProviderClass = Class.forName(loginIdentityProviderClassName, true, loginIdentityProviderClassLoader);
            Class<LoginIdentityProvider> loginIdentityProviderClass = rawLoginIdentityProviderClass.asSubclass(LoginIdentityProvider.class);
            Constructor<LoginIdentityProvider> constructor = loginIdentityProviderClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, loginIdentityProviderClass);
            this.performFieldInjection(instance, loginIdentityProviderClass);
            instance.initialize((LoginIdentityProviderInitializationContext)new StandardLoginIdentityProviderInitializationContext(identifier, this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return this.withNarLoader(instance);
    }

    private LoginIdentityProviderConfigurationContext loadLoginIdentityProviderConfiguration(Provider provider) {
        HashMap<String, String> providerProperties = new HashMap<String, String>();
        for (Property property : provider.getProperty()) {
            if (!StringUtils.isBlank((CharSequence)property.getEncryption())) {
                String decryptedValue = this.decryptValue(property.getValue(), property.getEncryption());
                providerProperties.put(property.getName(), decryptedValue);
                continue;
            }
            providerProperties.put(property.getName(), property.getValue());
        }
        return new StandardLoginIdentityProviderConfigurationContext(provider.getIdentifier(), providerProperties);
    }

    private String decryptValue(String cipherText, String protectionScheme) throws SensitivePropertyProtectionException {
        return this.getSensitivePropertyProviderFactory().getProvider(PropertyProtectionScheme.fromIdentifier((String)protectionScheme)).unprotect(cipherText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performMethodInjection(LoginIdentityProvider instance, Class loginIdentityProviderClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : loginIdentityProviderClass.getMethods()) {
            if (!method.isAnnotationPresent(LoginIdentityProviderContext.class)) continue;
            boolean isAccessible = method.isAccessible();
            method.setAccessible(true);
            try {
                Class<?> argumentType;
                Class<?>[] argumentTypes = method.getParameterTypes();
                if (argumentTypes.length != 1 || !NiFiProperties.class.isAssignableFrom(argumentType = argumentTypes[0])) continue;
                method.invoke((Object)instance, this.properties);
            }
            finally {
                method.setAccessible(isAccessible);
            }
        }
        Class parentClass = loginIdentityProviderClass.getSuperclass();
        if (parentClass != null && LoginIdentityProvider.class.isAssignableFrom(parentClass)) {
            this.performMethodInjection(instance, parentClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFieldInjection(LoginIdentityProvider instance, Class loginIdentityProviderClass) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : loginIdentityProviderClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(LoginIdentityProviderContext.class)) continue;
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Class<?> fieldType = field.getType();
                if (field.get(instance) != null || !NiFiProperties.class.isAssignableFrom(fieldType)) continue;
                field.set(instance, this.properties);
            }
            finally {
                field.setAccessible(isAccessible);
            }
        }
        Class parentClass = loginIdentityProviderClass.getSuperclass();
        if (parentClass != null && LoginIdentityProvider.class.isAssignableFrom(parentClass)) {
            this.performFieldInjection(instance, parentClass);
        }
    }

    private LoginIdentityProvider withNarLoader(final LoginIdentityProvider baseProvider) {
        return new LoginIdentityProvider(){

            public AuthenticationResponse authenticate(LoginCredentials credentials) {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    AuthenticationResponse authenticationResponse = baseProvider.authenticate(credentials);
                    return authenticationResponse;
                }
            }

            public void initialize(LoginIdentityProviderInitializationContext initializationContext) throws ProviderCreationException {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    baseProvider.initialize(initializationContext);
                }
            }

            public void onConfigured(LoginIdentityProviderConfigurationContext configurationContext) throws ProviderCreationException {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    baseProvider.onConfigured(configurationContext);
                }
            }

            public void preDestruction() throws ProviderDestructionException {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    baseProvider.preDestruction();
                }
            }
        };
    }

    public Class getObjectType() {
        return LoginIdentityProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.loginIdentityProvider != null) {
            this.loginIdentityProvider.preDestruction();
        }
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

