/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.revocation;

import org.apache.nifi.web.security.jwt.revocation.JwtRevocationService;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.BearerTokenErrors;

public class JwtRevocationValidator
implements OAuth2TokenValidator<Jwt> {
    private static final BearerTokenError REVOKED_ERROR = BearerTokenErrors.invalidToken((String)"Access Token Revoked");
    private static final OAuth2TokenValidatorResult FAILURE_RESULT = OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{REVOKED_ERROR});
    private final JwtRevocationService jwtRevocationService;

    public JwtRevocationValidator(JwtRevocationService jwtRevocationService) {
        this.jwtRevocationService = jwtRevocationService;
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        return this.jwtRevocationService.isRevoked(jwt.getId()) ? FAILURE_RESULT : OAuth2TokenValidatorResult.success();
    }
}

