/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.saml.SAMLStateManager;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.apache.nifi.web.security.util.CacheKey;
import org.apache.nifi.web.security.util.IdentityProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSAMLStateManager
implements SAMLStateManager {
    private static Logger LOGGER = LoggerFactory.getLogger(StandardSAMLStateManager.class);
    private BearerTokenProvider bearerTokenProvider;
    private final Cache<CacheKey, String> stateLookupForPendingRequests;
    private final Cache<CacheKey, String> jwtLookupForCompletedRequests;

    public StandardSAMLStateManager(BearerTokenProvider bearerTokenProvider) {
        this(bearerTokenProvider, 60, TimeUnit.SECONDS);
    }

    public StandardSAMLStateManager(BearerTokenProvider bearerTokenProvider, int cacheExpiration, TimeUnit units) {
        this.bearerTokenProvider = bearerTokenProvider;
        this.stateLookupForPendingRequests = Caffeine.newBuilder().expireAfterWrite((long)cacheExpiration, units).build();
        this.jwtLookupForCompletedRequests = Caffeine.newBuilder().expireAfterWrite((long)cacheExpiration, units).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createState(String requestIdentifier) {
        if (StringUtils.isBlank((String)requestIdentifier)) {
            throw new IllegalArgumentException("Request identifier is required");
        }
        CacheKey requestIdentifierKey = new CacheKey(requestIdentifier);
        String state = IdentityProviderUtils.generateStateValue();
        Cache<CacheKey, String> cache = this.stateLookupForPendingRequests;
        synchronized (cache) {
            String cachedState = (String)this.stateLookupForPendingRequests.get((Object)requestIdentifierKey, key -> state);
            if (!IdentityProviderUtils.timeConstantEqualityCheck(state, cachedState)) {
                throw new IllegalStateException("An existing login request is already in progress.");
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStateValid(String requestIdentifier, String proposedState) {
        if (StringUtils.isBlank((String)requestIdentifier)) {
            throw new IllegalArgumentException("Request identifier is required");
        }
        if (StringUtils.isBlank((String)proposedState)) {
            throw new IllegalArgumentException("Proposed state must be specified.");
        }
        CacheKey requestIdentifierKey = new CacheKey(requestIdentifier);
        Cache<CacheKey, String> cache = this.stateLookupForPendingRequests;
        synchronized (cache) {
            String state = (String)this.stateLookupForPendingRequests.getIfPresent((Object)requestIdentifierKey);
            if (state != null) {
                this.stateLookupForPendingRequests.invalidate((Object)requestIdentifierKey);
            }
            return state != null && IdentityProviderUtils.timeConstantEqualityCheck(state, proposedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createJwt(String requestIdentifier, LoginAuthenticationToken token) {
        if (StringUtils.isBlank((String)requestIdentifier)) {
            throw new IllegalStateException("Request identifier is required");
        }
        if (token == null) {
            throw new IllegalArgumentException("Token is required");
        }
        CacheKey requestIdentifierKey = new CacheKey(requestIdentifier);
        String bearerToken = this.bearerTokenProvider.getBearerToken(token);
        Cache<CacheKey, String> cache = this.jwtLookupForCompletedRequests;
        synchronized (cache) {
            String cachedJwt = (String)this.jwtLookupForCompletedRequests.get((Object)requestIdentifierKey, key -> bearerToken);
            if (!IdentityProviderUtils.timeConstantEqualityCheck(bearerToken, cachedJwt)) {
                throw new IllegalStateException("An existing login request is already in progress.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJwt(String requestIdentifier) {
        if (StringUtils.isBlank((String)requestIdentifier)) {
            throw new IllegalStateException("Request identifier is required");
        }
        CacheKey requestIdentifierKey = new CacheKey(requestIdentifier);
        Cache<CacheKey, String> cache = this.jwtLookupForCompletedRequests;
        synchronized (cache) {
            String jwt = (String)this.jwtLookupForCompletedRequests.getIfPresent((Object)requestIdentifierKey);
            if (jwt != null) {
                this.jwtLookupForCompletedRequests.invalidate((Object)requestIdentifierKey);
            }
            return jwt;
        }
    }
}

