/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.State;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.web.security.oidc.OidcIdentityProvider;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.apache.nifi.web.security.util.CacheKey;
import org.apache.nifi.web.security.util.IdentityProviderUtils;

public class OidcService {
    private final OidcIdentityProvider identityProvider;
    private final Cache<CacheKey, State> stateLookupForPendingRequests;
    private final Cache<CacheKey, String> jwtLookupForCompletedRequests;

    public OidcService(OidcIdentityProvider identityProvider) {
        this(identityProvider, 60, TimeUnit.SECONDS);
    }

    public OidcService(OidcIdentityProvider identityProvider, int duration, TimeUnit units) {
        if (identityProvider == null) {
            throw new RuntimeException("The OidcIdentityProvider must be specified.");
        }
        identityProvider.initializeProvider();
        this.identityProvider = identityProvider;
        this.stateLookupForPendingRequests = Caffeine.newBuilder().expireAfterWrite((long)duration, units).build();
        this.jwtLookupForCompletedRequests = Caffeine.newBuilder().expireAfterWrite((long)duration, units).build();
    }

    public boolean isOidcEnabled() {
        return this.identityProvider.isOidcEnabled();
    }

    public URI getAuthorizationEndpoint() {
        return this.identityProvider.getAuthorizationEndpoint();
    }

    public URI getEndSessionEndpoint() {
        return this.identityProvider.getEndSessionEndpoint();
    }

    public URI getRevocationEndpoint() {
        return this.identityProvider.getRevocationEndpoint();
    }

    public Scope getScope() {
        return this.identityProvider.getScope();
    }

    public String getClientId() {
        return this.identityProvider.getClientId().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State createState(String oidcRequestIdentifier) {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        CacheKey oidcRequestIdentifierKey = new CacheKey(oidcRequestIdentifier);
        State state = new State(IdentityProviderUtils.generateStateValue());
        Cache<CacheKey, State> cache = this.stateLookupForPendingRequests;
        synchronized (cache) {
            State cachedState = (State)this.stateLookupForPendingRequests.get((Object)oidcRequestIdentifierKey, key -> state);
            if (!IdentityProviderUtils.timeConstantEqualityCheck(state.getValue(), cachedState.getValue())) {
                throw new IllegalStateException("An existing login request is already in progress.");
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStateValid(String oidcRequestIdentifier, State proposedState) {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        if (proposedState == null) {
            throw new IllegalArgumentException("Proposed state must be specified.");
        }
        CacheKey oidcRequestIdentifierKey = new CacheKey(oidcRequestIdentifier);
        Cache<CacheKey, State> cache = this.stateLookupForPendingRequests;
        synchronized (cache) {
            State state = (State)this.stateLookupForPendingRequests.getIfPresent((Object)oidcRequestIdentifierKey);
            if (state != null) {
                this.stateLookupForPendingRequests.invalidate((Object)oidcRequestIdentifierKey);
            }
            return state != null && IdentityProviderUtils.timeConstantEqualityCheck(state.getValue(), proposedState.getValue());
        }
    }

    public LoginAuthenticationToken exchangeAuthorizationCodeForLoginAuthenticationToken(AuthorizationGrant authorizationGrant) throws IOException {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        return this.identityProvider.exchangeAuthorizationCodeforLoginAuthenticationToken(authorizationGrant);
    }

    public String exchangeAuthorizationCodeForAccessToken(AuthorizationGrant authorizationGrant) throws Exception {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        return this.identityProvider.exchangeAuthorizationCodeForAccessToken(authorizationGrant);
    }

    public String exchangeAuthorizationCodeForIdToken(AuthorizationGrant authorizationGrant) throws IOException {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        return this.identityProvider.exchangeAuthorizationCodeForIdToken(authorizationGrant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJwt(String oidcRequestIdentifier, String jwt) {
        CacheKey oidcRequestIdentifierKey = new CacheKey(oidcRequestIdentifier);
        Cache<CacheKey, String> cache = this.jwtLookupForCompletedRequests;
        synchronized (cache) {
            String cachedJwt = (String)this.jwtLookupForCompletedRequests.get((Object)oidcRequestIdentifierKey, key -> jwt);
            if (!IdentityProviderUtils.timeConstantEqualityCheck(jwt, cachedJwt)) {
                throw new IllegalStateException("An existing login request is already in progress.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJwt(String oidcRequestIdentifier) {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        CacheKey oidcRequestIdentifierKey = new CacheKey(oidcRequestIdentifier);
        Cache<CacheKey, String> cache = this.jwtLookupForCompletedRequests;
        synchronized (cache) {
            String jwt = (String)this.jwtLookupForCompletedRequests.getIfPresent((Object)oidcRequestIdentifierKey);
            if (jwt != null) {
                this.jwtLookupForCompletedRequests.invalidate((Object)oidcRequestIdentifierKey);
            }
            return jwt;
        }
    }
}

