/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.apache.nifi.admin.service.IdpUserGroupService;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.StandardAuthenticationEntryPoint;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.oidc.OidcConfigurationException;
import org.apache.nifi.web.security.oidc.OidcUrlPath;
import org.apache.nifi.web.security.oidc.authentication.StandardOidcIdTokenDecoderFactory;
import org.apache.nifi.web.security.oidc.client.web.AuthorizedClientExpirationCommand;
import org.apache.nifi.web.security.oidc.client.web.OidcBearerTokenRefreshFilter;
import org.apache.nifi.web.security.oidc.client.web.StandardAuthorizationRequestRepository;
import org.apache.nifi.web.security.oidc.client.web.StandardOAuth2AuthorizationRequestResolver;
import org.apache.nifi.web.security.oidc.client.web.StandardOidcAuthorizedClientRepository;
import org.apache.nifi.web.security.oidc.client.web.converter.AuthenticationResultConverter;
import org.apache.nifi.web.security.oidc.client.web.converter.AuthorizedClientConverter;
import org.apache.nifi.web.security.oidc.client.web.converter.StandardAuthorizedClientConverter;
import org.apache.nifi.web.security.oidc.logout.OidcLogoutFilter;
import org.apache.nifi.web.security.oidc.logout.OidcLogoutSuccessHandler;
import org.apache.nifi.web.security.oidc.registration.DisabledClientRegistrationRepository;
import org.apache.nifi.web.security.oidc.registration.StandardClientRegistrationProvider;
import org.apache.nifi.web.security.oidc.revocation.StandardTokenRevocationResponseClient;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponseClient;
import org.apache.nifi.web.security.oidc.web.authentication.OidcAuthenticationSuccessHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.DefaultRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.oidc.authentication.OidcAuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationCodeGrantFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2LoginAuthenticationFilter;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationEntryPointFailureHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
public class OidcSecurityConfiguration {
    private static final Duration REQUEST_EXPIRATION = Duration.ofSeconds(60L);
    private static final long AUTHORIZATION_REQUEST_CACHE_SIZE = 1000L;
    private static final Duration DEFAULT_SOCKET_TIMEOUT = Duration.ofSeconds(5L);
    private static final String NIFI_TRUSTSTORE_STRATEGY = "NIFI";
    private static final RequestCache nullRequestCache = new NullRequestCache();
    private final Duration keyRotationPeriod;
    private final NiFiProperties properties;
    private final StateManagerProvider stateManagerProvider;
    private final PropertyEncryptor propertyEncryptor;
    private final BearerTokenProvider bearerTokenProvider;
    private final BearerTokenResolver bearerTokenResolver;
    private final IdpUserGroupService idpUserGroupService;
    private final JwtDecoder jwtDecoder;
    private final LogoutRequestManager logoutRequestManager;

    @Autowired
    public OidcSecurityConfiguration(NiFiProperties properties, StateManagerProvider stateManagerProvider, PropertyEncryptor propertyEncryptor, BearerTokenProvider bearerTokenProvider, BearerTokenResolver bearerTokenResolver, IdpUserGroupService idpUserGroupService, JwtDecoder jwtDecoder, LogoutRequestManager logoutRequestManager) {
        this.properties = Objects.requireNonNull(properties, "Properties required");
        this.stateManagerProvider = Objects.requireNonNull(stateManagerProvider, "State Manager Provider required");
        this.propertyEncryptor = Objects.requireNonNull(propertyEncryptor, "Property Encryptor required");
        this.bearerTokenProvider = Objects.requireNonNull(bearerTokenProvider, "Bearer Token Provider required");
        this.bearerTokenResolver = Objects.requireNonNull(bearerTokenResolver, "Bearer Token Resolver required");
        this.idpUserGroupService = Objects.requireNonNull(idpUserGroupService, "User Group Service required");
        this.jwtDecoder = Objects.requireNonNull(jwtDecoder, "JWT Decoder required");
        this.logoutRequestManager = Objects.requireNonNull(logoutRequestManager, "Logout Request Manager required");
        this.keyRotationPeriod = properties.getSecurityUserJwsKeyRotationPeriod();
    }

    @Bean
    public OAuth2AuthorizationCodeGrantFilter oAuth2AuthorizationCodeGrantFilter(AuthenticationManager authenticationManager) {
        OAuth2AuthorizationCodeGrantFilter filter = new OAuth2AuthorizationCodeGrantFilter(this.clientRegistrationRepository(), (OAuth2AuthorizedClientRepository)this.authorizedClientRepository(), authenticationManager);
        filter.setAuthorizationRequestRepository(this.authorizationRequestRepository());
        filter.setRequestCache(nullRequestCache);
        return filter;
    }

    @Bean
    public OAuth2AuthorizationRequestRedirectFilter oAuth2AuthorizationRequestRedirectFilter() {
        StandardOAuth2AuthorizationRequestResolver authorizationRequestResolver = new StandardOAuth2AuthorizationRequestResolver(this.clientRegistrationRepository());
        OAuth2AuthorizationRequestRedirectFilter filter = new OAuth2AuthorizationRequestRedirectFilter((OAuth2AuthorizationRequestResolver)authorizationRequestResolver);
        filter.setAuthorizationRequestRepository(this.authorizationRequestRepository());
        filter.setRequestCache(nullRequestCache);
        return filter;
    }

    @Bean
    public OAuth2LoginAuthenticationFilter oAuth2LoginAuthenticationFilter(AuthenticationManager authenticationManager, StandardAuthenticationEntryPoint authenticationEntryPoint) {
        OAuth2LoginAuthenticationFilter filter = new OAuth2LoginAuthenticationFilter(this.clientRegistrationRepository(), (OAuth2AuthorizedClientRepository)this.authorizedClientRepository(), OidcUrlPath.CALLBACK.getPath());
        filter.setAuthenticationManager(authenticationManager);
        filter.setAuthorizationRequestRepository(this.authorizationRequestRepository());
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getAuthenticationSuccessHandler());
        filter.setAllowSessionCreation(false);
        filter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new NullAuthenticatedSessionStrategy());
        filter.setAuthenticationResultConverter((Converter)new AuthenticationResultConverter());
        AuthenticationEntryPointFailureHandler authenticationFailureHandler = new AuthenticationEntryPointFailureHandler((AuthenticationEntryPoint)authenticationEntryPoint);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)authenticationFailureHandler);
        return filter;
    }

    @Bean
    public OidcBearerTokenRefreshFilter oidcBearerTokenRefreshFilter() {
        DefaultRefreshTokenTokenResponseClient refreshTokenResponseClient = new DefaultRefreshTokenTokenResponseClient();
        refreshTokenResponseClient.setRestOperations(this.oidcRestOperations());
        String refreshWindowProperty = this.properties.getOidcTokenRefreshWindow();
        double refreshWindowSeconds = FormatUtils.getPreciseTimeDuration((String)refreshWindowProperty, (TimeUnit)TimeUnit.SECONDS);
        Duration refreshWindow = Duration.ofSeconds(Math.round(refreshWindowSeconds));
        return new OidcBearerTokenRefreshFilter(refreshWindow, this.bearerTokenProvider, this.bearerTokenResolver, this.jwtDecoder, this.authorizedClientRepository(), (OAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest>)refreshTokenResponseClient);
    }

    @Bean
    public OidcLogoutFilter oidcLogoutFilter() {
        return new OidcLogoutFilter(this.oidcLogoutSuccessHandler());
    }

    @Bean
    public LogoutSuccessHandler oidcLogoutSuccessHandler() {
        return new OidcLogoutSuccessHandler(this.logoutRequestManager, this.idpUserGroupService, this.clientRegistrationRepository(), this.authorizedClientRepository(), this.tokenRevocationResponseClient());
    }

    @Bean
    public OidcAuthorizationCodeAuthenticationProvider oidcAuthorizationCodeAuthenticationProvider() {
        OidcAuthorizationCodeAuthenticationProvider provider = new OidcAuthorizationCodeAuthenticationProvider(this.accessTokenResponseClient(), (OAuth2UserService)this.oidcUserService());
        provider.setJwtDecoderFactory(this.idTokenDecoderFactory());
        return provider;
    }

    @Bean
    public OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient() {
        DefaultAuthorizationCodeTokenResponseClient accessTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        accessTokenResponseClient.setRestOperations(this.oidcRestOperations());
        return accessTokenResponseClient;
    }

    @Bean
    public OidcUserService oidcUserService() {
        OidcUserService oidcUserService = new OidcUserService();
        DefaultOAuth2UserService userService = new DefaultOAuth2UserService();
        userService.setRestOperations(this.oidcRestOperations());
        oidcUserService.setOauth2UserService((OAuth2UserService)userService);
        return oidcUserService;
    }

    @Bean
    public StandardOidcAuthorizedClientRepository authorizedClientRepository() {
        StateManager stateManager = this.stateManagerProvider.getStateManager(StandardOidcAuthorizedClientRepository.class.getName());
        return new StandardOidcAuthorizedClientRepository(stateManager, this.authorizedClientConverter());
    }

    @Bean
    public AuthorizedClientExpirationCommand authorizedClientExpirationCommand() {
        AuthorizedClientExpirationCommand command = new AuthorizedClientExpirationCommand(this.authorizedClientRepository(), this.tokenRevocationResponseClient());
        this.oidcCommandScheduler().scheduleAtFixedRate((Runnable)command, this.keyRotationPeriod);
        return command;
    }

    @Bean
    public ThreadPoolTaskScheduler oidcCommandScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix(OidcSecurityConfiguration.class.getSimpleName());
        return scheduler;
    }

    @Bean
    public AuthorizedClientConverter authorizedClientConverter() {
        return new StandardAuthorizedClientConverter(this.propertyEncryptor, this.clientRegistrationRepository());
    }

    @Bean
    public AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository() {
        Cache caffeineCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(REQUEST_EXPIRATION).build();
        CaffeineCache cache = new CaffeineCache(StandardAuthorizationRequestRepository.class.getSimpleName(), caffeineCache);
        return new StandardAuthorizationRequestRepository((org.springframework.cache.Cache)cache);
    }

    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        String preferredJwdAlgorithm = this.properties.getOidcPreferredJwsAlgorithm();
        return new StandardOidcIdTokenDecoderFactory(preferredJwdAlgorithm, this.oidcRestOperations());
    }

    @Bean
    public TokenRevocationResponseClient tokenRevocationResponseClient() {
        return new StandardTokenRevocationResponseClient(this.oidcRestOperations(), this.clientRegistrationRepository());
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        DisabledClientRegistrationRepository clientRegistrationRepository;
        if (this.properties.isOidcEnabled()) {
            StandardClientRegistrationProvider clientRegistrationProvider = new StandardClientRegistrationProvider(this.properties, this.oidcRestOperations());
            ClientRegistration clientRegistration = clientRegistrationProvider.getClientRegistration();
            clientRegistrationRepository = new InMemoryClientRegistrationRepository(new ClientRegistration[]{clientRegistration});
        } else {
            clientRegistrationRepository = new DisabledClientRegistrationRepository();
        }
        return clientRegistrationRepository;
    }

    @Bean
    public RestOperations oidcRestOperations() {
        RestTemplate restTemplate = new RestTemplate(this.oidcClientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        restTemplate.setMessageConverters(Arrays.asList(new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter(), new StringHttpMessageConverter(), new MappingJackson2HttpMessageConverter()));
        return restTemplate;
    }

    @Bean
    public ClientHttpRequestFactory oidcClientHttpRequestFactory() {
        OkHttpClient httpClient = this.getHttpClient();
        return new OkHttp3ClientHttpRequestFactory(httpClient);
    }

    private OkHttpClient getHttpClient() {
        Duration connectTimeout = this.getTimeout(this.properties.getOidcConnectTimeout());
        Duration readTimeout = this.getTimeout(this.properties.getOidcReadTimeout());
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(connectTimeout).readTimeout(readTimeout);
        if (NIFI_TRUSTSTORE_STRATEGY.equals(this.properties.getOidcClientTruststoreStrategy())) {
            this.setSslSocketFactory(builder);
        }
        return builder.build();
    }

    private Duration getTimeout(String timeoutExpression) {
        try {
            double duration = FormatUtils.getPreciseTimeDuration((String)timeoutExpression, (TimeUnit)TimeUnit.MILLISECONDS);
            long rounded = Math.round(duration);
            return Duration.ofMillis(rounded);
        }
        catch (RuntimeException e) {
            return DEFAULT_SOCKET_TIMEOUT;
        }
    }

    private void setSslSocketFactory(OkHttpClient.Builder builder) {
        TlsConfiguration tlsConfiguration = StandardTlsConfiguration.fromNiFiProperties((NiFiProperties)this.properties);
        try {
            X509TrustManager trustManager = Objects.requireNonNull(SslContextFactory.getX509TrustManager((TlsConfiguration)tlsConfiguration), "TrustManager required");
            TrustManager[] trustManagers = new TrustManager[]{trustManager};
            SSLContext sslContext = Objects.requireNonNull(SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration, (TrustManager[])trustManagers), "SSLContext required");
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            builder.sslSocketFactory(sslSocketFactory, trustManager);
        }
        catch (TlsException e) {
            throw new OidcConfigurationException("OpenID Connect HTTP TLS configuration failed", e);
        }
    }

    private OidcAuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        ArrayList<String> userClaimNames = new ArrayList<String>();
        userClaimNames.add(this.properties.getOidcClaimIdentifyingUser());
        userClaimNames.addAll(this.properties.getOidcFallbackClaimsIdentifyingUser());
        return new OidcAuthenticationSuccessHandler(this.bearerTokenProvider, this.idpUserGroupService, IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties), IdentityMappingUtil.getGroupMappings((NiFiProperties)this.properties), userClaimNames, this.properties.getOidcClaimGroups());
    }
}

