/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.StandardAuthenticationEntryPoint;
import org.apache.nifi.web.security.jwt.converter.StandardJwtAuthenticationConverter;
import org.apache.nifi.web.security.jwt.jws.StandardJWSKeySelector;
import org.apache.nifi.web.security.jwt.jws.StandardJwsSignerProvider;
import org.apache.nifi.web.security.jwt.key.StandardVerificationKeySelector;
import org.apache.nifi.web.security.jwt.key.command.KeyExpirationCommand;
import org.apache.nifi.web.security.jwt.key.command.KeyGenerationCommand;
import org.apache.nifi.web.security.jwt.key.service.StandardVerificationKeyService;
import org.apache.nifi.web.security.jwt.key.service.VerificationKeyService;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.jwt.provider.IssuerProvider;
import org.apache.nifi.web.security.jwt.provider.StandardBearerTokenProvider;
import org.apache.nifi.web.security.jwt.provider.StandardIssuerProvider;
import org.apache.nifi.web.security.jwt.provider.SupportedClaim;
import org.apache.nifi.web.security.jwt.resolver.StandardBearerTokenResolver;
import org.apache.nifi.web.security.jwt.revocation.JwtLogoutListener;
import org.apache.nifi.web.security.jwt.revocation.JwtRevocationService;
import org.apache.nifi.web.security.jwt.revocation.JwtRevocationValidator;
import org.apache.nifi.web.security.jwt.revocation.StandardJwtLogoutListener;
import org.apache.nifi.web.security.jwt.revocation.StandardJwtRevocationService;
import org.apache.nifi.web.security.jwt.revocation.command.RevocationExpirationCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.authentication.BearerTokenAuthenticationFilter;
import org.springframework.security.web.AuthenticationEntryPoint;

@Configuration
public class JwtAuthenticationSecurityConfiguration {
    private static final Set<String> REQUIRED_CLAIMS = new HashSet<String>(Arrays.asList(SupportedClaim.ISSUER.getClaim(), SupportedClaim.SUBJECT.getClaim(), SupportedClaim.AUDIENCE.getClaim(), SupportedClaim.EXPIRATION.getClaim(), SupportedClaim.NOT_BEFORE.getClaim(), SupportedClaim.ISSUED_AT.getClaim(), SupportedClaim.JWT_ID.getClaim(), SupportedClaim.GROUPS.getClaim()));
    private final NiFiProperties niFiProperties;
    private final Authorizer authorizer;
    private final StateManagerProvider stateManagerProvider;
    private final Duration keyRotationPeriod;

    @Autowired
    public JwtAuthenticationSecurityConfiguration(NiFiProperties niFiProperties, Authorizer authorizer, StateManagerProvider stateManagerProvider) {
        this.niFiProperties = niFiProperties;
        this.authorizer = authorizer;
        this.stateManagerProvider = stateManagerProvider;
        this.keyRotationPeriod = niFiProperties.getSecurityUserJwsKeyRotationPeriod();
    }

    @Bean
    public BearerTokenAuthenticationFilter bearerTokenAuthenticationFilter(AuthenticationManager authenticationManager) {
        BearerTokenAuthenticationFilter bearerTokenAuthenticationFilter = new BearerTokenAuthenticationFilter(authenticationManager);
        bearerTokenAuthenticationFilter.setBearerTokenResolver(this.bearerTokenResolver());
        bearerTokenAuthenticationFilter.setAuthenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint());
        return bearerTokenAuthenticationFilter;
    }

    @Bean
    public BearerTokenResolver bearerTokenResolver() {
        return new StandardBearerTokenResolver();
    }

    @Bean
    public StandardAuthenticationEntryPoint authenticationEntryPoint() {
        BearerTokenAuthenticationEntryPoint bearerTokenAuthenticationEntryPoint = new BearerTokenAuthenticationEntryPoint();
        return new StandardAuthenticationEntryPoint(bearerTokenAuthenticationEntryPoint);
    }

    @Bean
    public JwtAuthenticationProvider jwtAuthenticationProvider() {
        JwtAuthenticationProvider jwtAuthenticationProvider = new JwtAuthenticationProvider(this.jwtDecoder());
        jwtAuthenticationProvider.setJwtAuthenticationConverter((Converter)this.jwtAuthenticationConverter());
        return jwtAuthenticationProvider;
    }

    @Bean
    public JwtDecoder jwtDecoder() {
        NimbusJwtDecoder jwtDecoder = new NimbusJwtDecoder(this.jwtProcessor());
        DelegatingOAuth2TokenValidator jwtValidator = new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{JwtValidators.createDefault(), this.jwtRevocationValidator()});
        jwtDecoder.setJwtValidator((OAuth2TokenValidator)jwtValidator);
        return jwtDecoder;
    }

    @Bean
    public OAuth2TokenValidator<Jwt> jwtRevocationValidator() {
        return new JwtRevocationValidator(this.jwtRevocationService());
    }

    @Bean
    public JwtRevocationService jwtRevocationService() {
        StateManager stateManager = this.stateManagerProvider.getStateManager(StandardJwtRevocationService.class.getName());
        return new StandardJwtRevocationService(stateManager);
    }

    @Bean
    public JwtLogoutListener jwtLogoutListener() {
        return new StandardJwtLogoutListener(this.jwtDecoder(), this.jwtRevocationService());
    }

    @Bean
    public JWTProcessor<SecurityContext> jwtProcessor() {
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWSKeySelector(this.jwsKeySelector());
        jwtProcessor.setJWTClaimsSetVerifier(this.claimsSetVerifier());
        return jwtProcessor;
    }

    @Bean
    public JWSKeySelector<SecurityContext> jwsKeySelector() {
        return new StandardJWSKeySelector<SecurityContext>(this.verificationKeySelector());
    }

    @Bean
    public JWTClaimsSetVerifier<SecurityContext> claimsSetVerifier() {
        return new DefaultJWTClaimsVerifier(null, REQUIRED_CLAIMS);
    }

    @Bean
    public StandardJwtAuthenticationConverter jwtAuthenticationConverter() {
        return new StandardJwtAuthenticationConverter(this.authorizer, this.niFiProperties);
    }

    @Bean
    public BearerTokenProvider bearerTokenProvider() {
        return new StandardBearerTokenProvider(this.jwsSignerProvider(), this.issuerProvider());
    }

    @Bean
    public IssuerProvider issuerProvider() {
        return new StandardIssuerProvider(this.niFiProperties.getProperty("nifi.web.https.host"), this.niFiProperties.getConfiguredHttpOrHttpsPort());
    }

    @Bean
    public StandardJwsSignerProvider jwsSignerProvider() {
        return new StandardJwsSignerProvider(this.verificationKeySelector());
    }

    @Bean
    public StandardVerificationKeySelector verificationKeySelector() {
        return new StandardVerificationKeySelector(this.verificationKeyService(), this.keyRotationPeriod);
    }

    @Bean
    public VerificationKeyService verificationKeyService() {
        StateManager stateManager = this.stateManagerProvider.getStateManager(StandardVerificationKeyService.class.getName());
        return new StandardVerificationKeyService(stateManager);
    }

    @Bean
    public KeyGenerationCommand keyGenerationCommand() {
        KeyGenerationCommand command = new KeyGenerationCommand(this.jwsSignerProvider(), this.verificationKeySelector());
        this.commandScheduler().scheduleAtFixedRate((Runnable)command, this.keyRotationPeriod);
        return command;
    }

    @Bean
    public KeyExpirationCommand keyExpirationCommand() {
        KeyExpirationCommand command = new KeyExpirationCommand(this.verificationKeyService());
        this.commandScheduler().scheduleAtFixedRate((Runnable)command, this.keyRotationPeriod);
        return command;
    }

    @Bean
    public RevocationExpirationCommand revocationExpirationCommand() {
        RevocationExpirationCommand command = new RevocationExpirationCommand(this.jwtRevocationService());
        this.commandScheduler().scheduleAtFixedRate((Runnable)command, this.keyRotationPeriod);
        return command;
    }

    @Bean
    public ThreadPoolTaskScheduler commandScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix(JwtAuthenticationSecurityConfiguration.class.getSimpleName());
        return scheduler;
    }
}

