/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.otp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.nifi.web.security.otp.OtpAuthenticationException;
import org.apache.nifi.web.security.token.OtpAuthenticationToken;
import org.apache.nifi.web.security.util.CacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpService {
    private static final Logger logger = LoggerFactory.getLogger(OtpService.class);
    private static final String HMAC_SHA256 = "HmacSHA256";
    protected static final int MAX_CACHE_SOFT_LIMIT = 100;
    private final Cache<CacheKey, String> downloadTokenCache;
    private final Cache<CacheKey, String> uiExtensionCache;

    public OtpService() {
        this(5, TimeUnit.MINUTES);
    }

    public OtpService(int duration, TimeUnit units) {
        this.downloadTokenCache = CacheBuilder.newBuilder().expireAfterWrite((long)duration, units).build();
        this.uiExtensionCache = CacheBuilder.newBuilder().expireAfterWrite((long)duration, units).build();
    }

    public String generateDownloadToken(OtpAuthenticationToken authenticationToken) {
        return this.generateToken(this.downloadTokenCache.asMap(), authenticationToken);
    }

    public String getAuthenticationFromDownloadToken(String token) throws OtpAuthenticationException {
        return this.getAuthenticationFromToken(this.downloadTokenCache.asMap(), token);
    }

    public String generateUiExtensionToken(OtpAuthenticationToken authenticationToken) {
        return this.generateToken(this.uiExtensionCache.asMap(), authenticationToken);
    }

    public String getAuthenticationFromUiExtensionToken(String token) throws OtpAuthenticationException {
        return this.getAuthenticationFromToken(this.uiExtensionCache.asMap(), token);
    }

    private String generateToken(ConcurrentMap<CacheKey, String> cache, OtpAuthenticationToken authenticationToken) {
        if (cache.size() >= 100) {
            throw new IllegalStateException("The maximum number of single use tokens have been issued.");
        }
        CacheKey cacheKey = new CacheKey(this.hash(authenticationToken));
        cache.putIfAbsent(cacheKey, authenticationToken.getName());
        return cacheKey.getKey();
    }

    private String getAuthenticationFromToken(ConcurrentMap<CacheKey, String> cache, String token) throws OtpAuthenticationException {
        String authenticatedUser = (String)cache.remove(new CacheKey(token));
        if (authenticatedUser == null) {
            throw new OtpAuthenticationException("Unable to validate the access token.");
        }
        return authenticatedUser;
    }

    private String hash(OtpAuthenticationToken authenticationToken) {
        try {
            String input = authenticationToken.getName() + "-" + System.nanoTime();
            SecureRandom secureRandom = new SecureRandom();
            byte[] randomBytes = new byte[32];
            secureRandom.nextBytes(randomBytes);
            SecretKeySpec secret = new SecretKeySpec(randomBytes, HMAC_SHA256);
            Mac hmacSha256 = Mac.getInstance(HMAC_SHA256);
            hmacSha256.init(secret);
            byte[] output = hmacSha256.doFinal(input.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64URLSafeString((byte[])output);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            String errorMessage = "There was an error generating the OTP";
            logger.error("There was an error generating the OTP", (Throwable)e);
            throw new IllegalStateException("Unable to generate single use token.");
        }
    }
}

