/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.UserContextKeys;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationProvider;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.apache.nifi.web.security.UntrustedProxyException;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.apache.nifi.web.security.x509.X509AuthenticationRequestToken;
import org.apache.nifi.web.security.x509.X509IdentityProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class X509AuthenticationProvider
extends NiFiAuthenticationProvider {
    private X509IdentityProvider certificateIdentityProvider;
    private Authorizer authorizer;

    public X509AuthenticationProvider(X509IdentityProvider certificateIdentityProvider, Authorizer authorizer, NiFiProperties nifiProperties) {
        super(nifiProperties);
        this.certificateIdentityProvider = certificateIdentityProvider;
        this.authorizer = authorizer;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AuthenticationResponse authenticationResponse;
        X509AuthenticationRequestToken request = (X509AuthenticationRequestToken)authentication;
        try {
            authenticationResponse = this.certificateIdentityProvider.authenticate(request.getCertificates());
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidAuthenticationException(iae.getMessage(), iae);
        }
        if (StringUtils.isBlank((CharSequence)request.getProxiedEntitiesChain())) {
            String mappedIdentity = this.mapIdentity(authenticationResponse.getIdentity());
            return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails((NiFiUser)new StandardNiFiUser(mappedIdentity, request.getClientAddress())));
        }
        ArrayList<String> proxyChain = new ArrayList<String>(ProxiedEntitiesUtils.tokenizeProxiedEntitiesChain(request.getProxiedEntitiesChain()));
        proxyChain.add(authenticationResponse.getIdentity());
        NiFiUser proxy = null;
        ListIterator chainIter = proxyChain.listIterator(proxyChain.size());
        while (chainIter.hasPrevious()) {
            AuthorizationRequest proxyAuthorizationRequest;
            AuthorizationResult proxyAuthorizationResult;
            String identity = (String)chainIter.previous();
            boolean isAnonymous = StringUtils.isBlank((CharSequence)identity);
            identity = isAnonymous ? "anonymous" : this.mapIdentity(identity);
            if (chainIter.hasPrevious() && !AuthorizationResult.Result.Approved.equals((Object)(proxyAuthorizationResult = this.authorizer.authorize(proxyAuthorizationRequest = new AuthorizationRequest.Builder().identity(identity).anonymous(Boolean.valueOf(isAnonymous)).accessAttempt(Boolean.valueOf(true)).action(RequestAction.WRITE).resource(ResourceFactory.getProxyResource()).userContext(proxy == null ? this.getUserContext(request) : null).build())).getResult())) {
                throw new UntrustedProxyException(String.format("Untrusted proxy %s", identity));
            }
            String clientAddress = proxy == null ? request.getClientAddress() : null;
            proxy = X509AuthenticationProvider.createUser(identity, proxy, clientAddress, isAnonymous);
        }
        return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails(proxy));
    }

    protected static NiFiUser createUser(String identity, NiFiUser chain, String clientAddress, boolean isAnonymous) {
        if (isAnonymous) {
            return StandardNiFiUser.populateAnonymousUser((NiFiUser)chain, (String)clientAddress);
        }
        return new StandardNiFiUser(identity, chain, clientAddress);
    }

    private Map<String, String> getUserContext(X509AuthenticationRequestToken request) {
        HashMap<String, String> userContext;
        if (!StringUtils.isBlank((CharSequence)request.getClientAddress())) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), request.getClientAddress());
        } else {
            userContext = null;
        }
        return userContext;
    }

    public boolean supports(Class<?> authentication) {
        return X509AuthenticationRequestToken.class.isAssignableFrom(authentication);
    }
}

