/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.security.NiFiAuthenticationFilter;
import org.apache.nifi.web.security.jwt.JwtAuthenticationRequestToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class JwtAuthenticationFilter
extends NiFiAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(JwtAuthenticationFilter.class);
    public static final String AUTHORIZATION = "Authorization";
    public static final String BEARER = "Bearer ";

    @Override
    public Authentication attemptAuthentication(HttpServletRequest request) {
        if (!request.isSecure()) {
            return null;
        }
        String authorization = request.getHeader(AUTHORIZATION);
        if (authorization == null || !StringUtils.startsWith((CharSequence)authorization, (CharSequence)BEARER)) {
            return null;
        }
        String token = StringUtils.substringAfterLast((String)authorization, (String)" ");
        return new JwtAuthenticationRequestToken(token, request.getRemoteAddr());
    }
}

