/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.web.authentication;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.ApplicationCookieService;
import org.apache.nifi.web.security.cookie.StandardApplicationCookieService;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.apache.nifi.web.util.RequestUriBuilder;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.AuthenticatedPrincipal;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;

public class Saml2AuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private static final String UI_PATH = "/nifi/";
    private static final String ROOT_PATH = "/";
    private final ApplicationCookieService applicationCookieService = new StandardApplicationCookieService();
    private final BearerTokenProvider bearerTokenProvider;
    private final List<IdentityMapping> userIdentityMappings;
    private final List<IdentityMapping> groupIdentityMappings;
    private final Duration expiration;
    private final String issuer;
    private Converter<Saml2AuthenticatedPrincipal, String> identityConverter = AuthenticatedPrincipal::getName;

    public Saml2AuthenticationSuccessHandler(BearerTokenProvider bearerTokenProvider, List<IdentityMapping> userIdentityMappings, List<IdentityMapping> groupIdentityMappings, Duration expiration, String issuer) {
        this.bearerTokenProvider = Objects.requireNonNull(bearerTokenProvider, "Bearer Token Provider required");
        this.userIdentityMappings = Objects.requireNonNull(userIdentityMappings, "User Identity Mappings required");
        this.groupIdentityMappings = Objects.requireNonNull(groupIdentityMappings, "Group Identity Mappings required");
        this.expiration = Objects.requireNonNull(expiration, "Expiration required");
        this.issuer = Objects.requireNonNull(issuer, "Issuer required");
    }

    public void setIdentityConverter(Converter<Saml2AuthenticatedPrincipal, String> identityConverter) {
        this.identityConverter = Objects.requireNonNull(identityConverter, "Converter required");
    }

    public String determineTargetUrl(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        URI resourceUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).path(ROOT_PATH).build();
        this.processAuthentication(response, authentication, resourceUri);
        URI targetUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).path(UI_PATH).build();
        return targetUri.toString();
    }

    private void processAuthentication(HttpServletResponse response, Authentication authentication, URI resourceUri) {
        String identity = this.getIdentity(authentication);
        Set<String> groups = this.getGroups(authentication);
        String bearerToken = this.getBearerToken(identity, groups);
        this.applicationCookieService.addSessionCookie(resourceUri, response, ApplicationCookieName.AUTHORIZATION_BEARER, bearerToken);
    }

    private String getBearerToken(String identity, Set<String> groups) {
        Set authorities = groups.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(identity, identity, this.expiration.toMillis(), this.issuer, authorities);
        return this.bearerTokenProvider.getBearerToken(loginAuthenticationToken);
    }

    private String getIdentity(Authentication authentication) {
        String identity;
        Object principal = authentication.getPrincipal();
        if (principal instanceof Saml2AuthenticatedPrincipal) {
            Saml2AuthenticatedPrincipal authenticatedPrincipal = (Saml2AuthenticatedPrincipal)principal;
            identity = (String)this.identityConverter.convert((Object)authenticatedPrincipal);
        } else {
            identity = authentication.getName();
        }
        return IdentityMappingUtil.mapIdentity((String)identity, this.userIdentityMappings);
    }

    private Set<String> getGroups(Authentication authentication) {
        return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).map(group -> IdentityMappingUtil.mapIdentity((String)group, this.groupIdentityMappings)).collect(Collectors.toSet());
    }
}

