/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.client.web;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Objects;
import org.apache.nifi.web.util.RequestUriBuilder;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.web.util.UriComponentsBuilder;

public class StandardOAuth2AuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private final OAuth2AuthorizationRequestResolver resolver;

    public StandardOAuth2AuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        Objects.requireNonNull(clientRegistrationRepository, "Repository required");
        this.resolver = new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        OAuth2AuthorizationRequest authorizationRequest = this.resolver.resolve(request);
        return this.getResolvedAuthorizationRequest(authorizationRequest, request);
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        OAuth2AuthorizationRequest authorizationRequest = this.resolver.resolve(request, clientRegistrationId);
        return this.getResolvedAuthorizationRequest(authorizationRequest, request);
    }

    private OAuth2AuthorizationRequest getResolvedAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, HttpServletRequest request) {
        OAuth2AuthorizationRequest resolvedAuthorizationRequest;
        if (authorizationRequest == null) {
            resolvedAuthorizationRequest = null;
        } else {
            String redirectUri = authorizationRequest.getRedirectUri();
            if (redirectUri == null) {
                resolvedAuthorizationRequest = authorizationRequest;
            } else {
                String requestBasedRedirectUri = this.getRequestBasedRedirectUri(redirectUri, request);
                resolvedAuthorizationRequest = OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)authorizationRequest).redirectUri(requestBasedRedirectUri).build();
            }
        }
        return resolvedAuthorizationRequest;
    }

    private String getRequestBasedRedirectUri(String redirectUri, HttpServletRequest request) {
        String redirectUriPath = UriComponentsBuilder.fromUriString((String)redirectUri).build().getPath();
        URI baseUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).path(redirectUriPath).build();
        return UriComponentsBuilder.fromUriString((String)redirectUri).scheme(baseUri.getScheme()).host(baseUri.getHost()).port(baseUri.getPort()).replacePath(baseUri.getPath()).build().toUriString();
    }
}

