/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import com.nimbusds.jose.proc.JWSVerifierFactory;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.jwt.converter.StandardIssuerJwtDecoder;
import org.apache.nifi.web.security.jwt.jws.StandardJWSKeySelector;
import org.apache.nifi.web.security.jwt.key.Ed25519VerifierFactory;
import org.apache.nifi.web.security.jwt.key.StandardVerificationKeySelector;
import org.apache.nifi.web.security.jwt.key.service.StandardVerificationKeyService;
import org.apache.nifi.web.security.jwt.key.service.VerificationKeyService;
import org.apache.nifi.web.security.jwt.provider.SupportedClaim;
import org.apache.nifi.web.security.jwt.revocation.JwtRevocationService;
import org.apache.nifi.web.security.jwt.revocation.JwtRevocationValidator;
import org.apache.nifi.web.security.jwt.revocation.StandardJwtRevocationService;
import org.apache.nifi.web.security.oidc.authentication.AccessTokenDecoderFactory;
import org.apache.nifi.web.security.oidc.authentication.StandardOidcIdTokenDecoderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.web.client.RestOperations;

@Configuration
public class JwtDecoderConfiguration {
    private static final Set<String> REQUIRED_CLAIMS = new HashSet<String>(Arrays.asList(SupportedClaim.ISSUER.getClaim(), SupportedClaim.SUBJECT.getClaim(), SupportedClaim.AUDIENCE.getClaim(), SupportedClaim.EXPIRATION.getClaim(), SupportedClaim.NOT_BEFORE.getClaim(), SupportedClaim.ISSUED_AT.getClaim(), SupportedClaim.JWT_ID.getClaim(), SupportedClaim.GROUPS.getClaim()));
    private final NiFiProperties properties;
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final RestOperations oidcRestOperations;
    private final StateManagerProvider stateManagerProvider;
    private final Duration keyRotationPeriod;

    @Autowired
    public JwtDecoderConfiguration(NiFiProperties properties, ClientRegistrationRepository clientRegistrationRepository, @Qualifier(value="oidcRestOperations") RestOperations oidcRestOperations, StateManagerProvider stateManagerProvider) {
        this.properties = Objects.requireNonNull(properties, "Application properties required");
        this.clientRegistrationRepository = Objects.requireNonNull(clientRegistrationRepository, "Client Registration Repository required");
        this.oidcRestOperations = Objects.requireNonNull(oidcRestOperations, "OIDC REST Operations required");
        this.stateManagerProvider = Objects.requireNonNull(stateManagerProvider, "State Manager Provider required");
        this.keyRotationPeriod = properties.getSecurityUserJwsKeyRotationPeriod();
    }

    @Bean
    public JwtDecoder jwtDecoder() {
        NimbusJwtDecoder applicationJwtDecoder = new NimbusJwtDecoder(this.jwtProcessor());
        applicationJwtDecoder.setJwtValidator(this.jwtTokenValidator());
        AccessTokenDecoderFactory accessTokenDecoderFactory = new AccessTokenDecoderFactory(this.properties.getOidcPreferredJwsAlgorithm(), this.oidcRestOperations);
        return new StandardIssuerJwtDecoder((JwtDecoder)applicationJwtDecoder, accessTokenDecoderFactory, this.clientRegistrationRepository);
    }

    @Bean
    public JWTProcessor<SecurityContext> jwtProcessor() {
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        StandardJWSKeySelector jwsKeySelector = new StandardJWSKeySelector(this.verificationKeySelector());
        jwtProcessor.setJWSKeySelector(jwsKeySelector);
        DefaultJWTClaimsVerifier claimsSetVerifier = new DefaultJWTClaimsVerifier(null, REQUIRED_CLAIMS);
        jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)claimsSetVerifier);
        jwtProcessor.setJWSVerifierFactory((JWSVerifierFactory)new Ed25519VerifierFactory());
        return jwtProcessor;
    }

    @Bean
    public OAuth2TokenValidator<Jwt> jwtTokenValidator() {
        JwtRevocationValidator jwtRevocationValidator = new JwtRevocationValidator(this.jwtRevocationService());
        return new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{JwtValidators.createDefault(), jwtRevocationValidator});
    }

    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        String preferredJwdAlgorithm = this.properties.getOidcPreferredJwsAlgorithm();
        return new StandardOidcIdTokenDecoderFactory(preferredJwdAlgorithm, this.oidcRestOperations);
    }

    @Bean
    public JwtRevocationService jwtRevocationService() {
        StateManager stateManager = this.stateManagerProvider.getStateManager(StandardJwtRevocationService.class.getName());
        return new StandardJwtRevocationService(stateManager);
    }

    @Bean
    public StandardVerificationKeySelector verificationKeySelector() {
        return new StandardVerificationKeySelector(this.verificationKeyService(), this.keyRotationPeriod);
    }

    @Bean
    public VerificationKeyService verificationKeyService() {
        StateManager stateManager = this.stateManagerProvider.getStateManager(StandardVerificationKeyService.class.getName());
        return new StandardVerificationKeyService(stateManager);
    }
}

