/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.saml2.SamlUrlPath;
import org.apache.nifi.web.security.saml2.registration.EntityDescriptorCustomizer;
import org.apache.nifi.web.security.saml2.registration.Saml2RegistrationProperty;
import org.apache.nifi.web.security.saml2.registration.StandardRelyingPartyRegistrationRepository;
import org.apache.nifi.web.security.saml2.service.authentication.ResponseAuthenticationConverter;
import org.apache.nifi.web.security.saml2.service.web.StandardRelyingPartyRegistrationResolver;
import org.apache.nifi.web.security.saml2.service.web.StandardSaml2AuthenticationRequestRepository;
import org.apache.nifi.web.security.saml2.web.authentication.Saml2AuthenticationSuccessHandler;
import org.apache.nifi.web.security.saml2.web.authentication.identity.AttributeNameIdentityConverter;
import org.apache.nifi.web.security.saml2.web.authentication.logout.Saml2LocalLogoutFilter;
import org.apache.nifi.web.security.saml2.web.authentication.logout.Saml2LogoutSuccessHandler;
import org.apache.nifi.web.security.saml2.web.authentication.logout.Saml2SingleLogoutFilter;
import org.apache.nifi.web.security.saml2.web.authentication.logout.Saml2SingleLogoutHandler;
import org.apache.nifi.web.security.saml2.web.authentication.logout.StandardSaml2LogoutRequestRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSamlLogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSamlLogoutResponseValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponseValidator;
import org.springframework.security.saml2.provider.service.metadata.OpenSamlMetadataResolver;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResolver;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationTokenConverter;
import org.springframework.security.saml2.provider.service.web.Saml2MetadataFilter;
import org.springframework.security.saml2.provider.service.web.Saml2WebSsoAuthenticationRequestFilter;
import org.springframework.security.saml2.provider.service.web.authentication.OpenSaml4AuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2AuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2WebSsoAuthenticationFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4LogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2RelyingPartyInitiatedLogoutSuccessHandler;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
public class SamlAuthenticationSecurityConfiguration {
    private static final Duration REQUEST_EXPIRATION = Duration.ofSeconds(60L);
    private static final long REQUEST_MAXIMUM_CACHE_SIZE = 1000L;
    private final NiFiProperties properties;
    private final BearerTokenProvider bearerTokenProvider;
    private final LogoutRequestManager logoutRequestManager;
    private final SSLContext sslContext;
    private final X509ExtendedKeyManager keyManager;
    private final X509ExtendedTrustManager trustManager;

    public SamlAuthenticationSecurityConfiguration(@Autowired NiFiProperties properties, @Autowired BearerTokenProvider bearerTokenProvider, @Autowired LogoutRequestManager logoutRequestManager, @Autowired(required=false) SSLContext sslContext, @Autowired(required=false) X509ExtendedKeyManager keyManager, @Autowired(required=false) X509ExtendedTrustManager trustManager) {
        this.properties = Objects.requireNonNull(properties, "Properties required");
        this.bearerTokenProvider = Objects.requireNonNull(bearerTokenProvider, "Bearer Token Provider required");
        this.logoutRequestManager = Objects.requireNonNull(logoutRequestManager, "Logout Request Manager required");
        this.sslContext = sslContext;
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    @Bean
    public Saml2MetadataFilter saml2MetadataFilter() {
        Saml2MetadataFilter filter = new Saml2MetadataFilter(this.relyingPartyRegistrationResolver(), this.saml2MetadataResolver());
        filter.setRequestMatcher((RequestMatcher)new AntPathRequestMatcher(SamlUrlPath.METADATA.getPath()));
        return filter;
    }

    @Bean
    public Saml2WebSsoAuthenticationRequestFilter saml2WebSsoAuthenticationRequestFilter() {
        Saml2WebSsoAuthenticationRequestFilter filter = new Saml2WebSsoAuthenticationRequestFilter(this.saml2AuthenticationRequestResolver());
        filter.setAuthenticationRequestRepository(this.saml2AuthenticationRequestRepository());
        return filter;
    }

    @Bean
    public Saml2WebSsoAuthenticationFilter saml2WebSsoAuthenticationFilter(AuthenticationManager authenticationManager) {
        Saml2AuthenticationTokenConverter authenticationTokenConverter = new Saml2AuthenticationTokenConverter(this.relyingPartyRegistrationResolver());
        Saml2WebSsoAuthenticationFilter filter = new Saml2WebSsoAuthenticationFilter((AuthenticationConverter)authenticationTokenConverter, SamlUrlPath.LOGIN_RESPONSE_REGISTRATION_ID.getPath());
        filter.setAuthenticationManager(authenticationManager);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getAuthenticationSuccessHandler());
        filter.setAuthenticationRequestRepository(this.saml2AuthenticationRequestRepository());
        filter.setAllowSessionCreation(false);
        filter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new NullAuthenticatedSessionStrategy());
        return filter;
    }

    @Bean
    public Saml2SingleLogoutFilter saml2SingleLogoutFilter() {
        return new Saml2SingleLogoutFilter(this.logoutRequestManager, (LogoutSuccessHandler)this.saml2SingleLogoutSuccessHandler());
    }

    @Bean
    public Saml2LogoutRequestFilter saml2LogoutRequestFilter() {
        Saml2LogoutRequestFilter filter = new Saml2LogoutRequestFilter(this.relyingPartyRegistrationResolver(), this.saml2LogoutRequestValidator(), this.saml2LogoutResponseResolver(), new LogoutHandler[]{this.saml2SingleLogoutHandler()});
        filter.setLogoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher(SamlUrlPath.SINGLE_LOGOUT_RESPONSE.getPath()));
        return filter;
    }

    @Bean
    public Saml2LogoutResponseFilter saml2LogoutResponseFilter() {
        Saml2LogoutResponseFilter saml2LogoutResponseFilter = new Saml2LogoutResponseFilter(this.relyingPartyRegistrationResolver(), this.saml2LogoutResponseValidator(), (LogoutSuccessHandler)this.saml2LogoutSuccessHandler());
        saml2LogoutResponseFilter.setLogoutRequestRepository(this.saml2LogoutRequestRepository());
        saml2LogoutResponseFilter.setLogoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher(SamlUrlPath.SINGLE_LOGOUT_RESPONSE.getPath()));
        return saml2LogoutResponseFilter;
    }

    @Bean
    public Saml2SingleLogoutHandler saml2SingleLogoutHandler() {
        return new Saml2SingleLogoutHandler();
    }

    @Bean
    public Saml2LocalLogoutFilter saml2LocalLogoutFilter() {
        return new Saml2LocalLogoutFilter(this.saml2LogoutSuccessHandler());
    }

    @Bean
    public OpenSaml4AuthenticationProvider openSamlAuthenticationProvider() {
        OpenSaml4AuthenticationProvider provider = new OpenSaml4AuthenticationProvider();
        ResponseAuthenticationConverter responseAuthenticationConverter = new ResponseAuthenticationConverter(this.properties.getSamlGroupAttributeName());
        provider.setResponseAuthenticationConverter((Converter)responseAuthenticationConverter);
        return provider;
    }

    @Bean
    public Saml2AuthenticationRequestResolver saml2AuthenticationRequestResolver() {
        return new OpenSaml4AuthenticationRequestResolver(this.relyingPartyRegistrationResolver());
    }

    @Bean
    public Saml2LogoutRequestValidator saml2LogoutRequestValidator() {
        return new OpenSamlLogoutRequestValidator();
    }

    @Bean
    public Saml2LogoutResponseValidator saml2LogoutResponseValidator() {
        return new OpenSamlLogoutResponseValidator();
    }

    @Bean
    public Saml2LogoutRequestResolver saml2LogoutRequestResolver() {
        return new OpenSaml4LogoutRequestResolver(this.relyingPartyRegistrationResolver());
    }

    @Bean
    public Saml2LogoutResponseResolver saml2LogoutResponseResolver() {
        return new OpenSaml4LogoutResponseResolver(this.relyingPartyRegistrationResolver());
    }

    @Bean
    public Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> saml2AuthenticationRequestRepository() {
        Cache caffeineCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(REQUEST_EXPIRATION).build();
        CaffeineCache cache = new CaffeineCache(Saml2AuthenticationRequestRepository.class.getSimpleName(), caffeineCache);
        return new StandardSaml2AuthenticationRequestRepository((org.springframework.cache.Cache)cache);
    }

    @Bean
    public RelyingPartyRegistrationResolver relyingPartyRegistrationResolver() {
        return new StandardRelyingPartyRegistrationResolver(this.relyingPartyRegistrationRepository(), this.properties.getAllowedContextPathsAsList());
    }

    @Bean
    public RelyingPartyRegistrationRepository relyingPartyRegistrationRepository() {
        return this.properties.isSamlEnabled() ? new StandardRelyingPartyRegistrationRepository(this.properties, this.sslContext, this.keyManager, this.trustManager) : this.getDisabledRelyingPartyRegistrationRepository();
    }

    @Bean
    public Saml2MetadataResolver saml2MetadataResolver() {
        OpenSamlMetadataResolver resolver = new OpenSamlMetadataResolver();
        EntityDescriptorCustomizer customizer = new EntityDescriptorCustomizer(this.properties.isSamlWantAssertionsSigned(), this.properties.isSamlRequestSigningEnabled());
        resolver.setEntityDescriptorCustomizer((Consumer)customizer);
        return resolver;
    }

    @Bean
    public Saml2LogoutSuccessHandler saml2LogoutSuccessHandler() {
        return new Saml2LogoutSuccessHandler(this.logoutRequestManager);
    }

    @Bean
    public Saml2RelyingPartyInitiatedLogoutSuccessHandler saml2SingleLogoutSuccessHandler() {
        Saml2RelyingPartyInitiatedLogoutSuccessHandler handler = new Saml2RelyingPartyInitiatedLogoutSuccessHandler(this.saml2LogoutRequestResolver());
        handler.setLogoutRequestRepository(this.saml2LogoutRequestRepository());
        return handler;
    }

    @Bean
    public Saml2LogoutRequestRepository saml2LogoutRequestRepository() {
        Cache caffeineCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(REQUEST_EXPIRATION).build();
        CaffeineCache cache = new CaffeineCache(Saml2LogoutRequestRepository.class.getSimpleName(), caffeineCache);
        return new StandardSaml2LogoutRequestRepository((org.springframework.cache.Cache)cache);
    }

    private Saml2AuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        long authenticationExpiration = (long)FormatUtils.getPreciseTimeDuration((String)this.properties.getSamlAuthenticationExpiration(), (TimeUnit)TimeUnit.MILLISECONDS);
        Duration expiration = Duration.ofMillis(authenticationExpiration);
        Saml2AuthenticationSuccessHandler handler = new Saml2AuthenticationSuccessHandler(this.bearerTokenProvider, IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties), IdentityMappingUtil.getGroupMappings((NiFiProperties)this.properties), expiration);
        String identityAttributeName = this.properties.getSamlIdentityAttributeName();
        if (StringUtils.isNotBlank((String)identityAttributeName)) {
            AttributeNameIdentityConverter identityConverter = new AttributeNameIdentityConverter(identityAttributeName);
            handler.setIdentityConverter(identityConverter);
        }
        return handler;
    }

    private RelyingPartyRegistrationRepository getDisabledRelyingPartyRegistrationRepository() {
        RelyingPartyRegistration registration = RelyingPartyRegistration.withRegistrationId((String)Saml2RegistrationProperty.REGISTRATION_ID.getProperty()).entityId(Saml2RegistrationProperty.REGISTRATION_ID.getProperty()).assertingPartyDetails(assertingPartyDetails -> {
            assertingPartyDetails.entityId(Saml2RegistrationProperty.REGISTRATION_ID.getProperty());
            assertingPartyDetails.singleSignOnServiceLocation(SamlUrlPath.LOGIN_RESPONSE_REGISTRATION_ID.getPath());
        }).build();
        return new InMemoryRelyingPartyRegistrationRepository(new RelyingPartyRegistration[]{registration});
    }
}

