/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.key;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.impl.EdDSAProvider;
import com.nimbusds.jose.util.Base64URL;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Objects;

public class Ed25519Signer
extends EdDSAProvider
implements JWSSigner {
    private static final String SIGNING_ALGORITHM = "Ed25519";
    private final PrivateKey privateKey;

    public Ed25519Signer(PrivateKey privateKey) {
        this.privateKey = Objects.requireNonNull(privateKey, "Private Key required");
    }

    public Base64URL sign(JWSHeader jwsHeader, byte[] bytes) throws JOSEException {
        JWSAlgorithm algorithm = jwsHeader.getAlgorithm();
        if (JWSAlgorithm.EdDSA.equals((Object)algorithm)) {
            try {
                Signature signature = Signature.getInstance(SIGNING_ALGORITHM);
                signature.initSign(this.privateKey);
                signature.update(bytes);
                byte[] jwsSignature = signature.sign();
                return Base64URL.encode((byte[])jwsSignature);
            }
            catch (GeneralSecurityException e) {
                throw new JOSEException("Ed25519 signing failed", (Throwable)e);
            }
        }
        throw new JOSEException("JWS Algorithm EdDSA not found [%s]".formatted(algorithm));
    }
}

