/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.key;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.KeyTypeException;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.proc.JWSVerifierFactory;
import java.security.Key;
import java.security.PublicKey;
import java.util.Set;
import org.apache.nifi.web.security.jwt.key.Ed25519Verifier;

public class Ed25519VerifierFactory
implements JWSVerifierFactory {
    private static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS = Set.of(JWSAlgorithm.EdDSA);
    private final JCAContext jcaContext = new JCAContext();

    public JWSVerifier createJWSVerifier(JWSHeader jwsHeader, Key key) throws JOSEException {
        JWSAlgorithm algorithm = jwsHeader.getAlgorithm();
        if (SUPPORTED_ALGORITHMS.contains(algorithm)) {
            if (key instanceof PublicKey) {
                PublicKey publicKey = (PublicKey)key;
                Ed25519Verifier verifier = new Ed25519Verifier(publicKey);
                verifier.getJCAContext().setProvider(this.jcaContext.getProvider());
                return verifier;
            }
            throw new KeyTypeException(PublicKey.class);
        }
        throw new JOSEException("JWS Algorithm [%s] not supported".formatted(algorithm));
    }

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    public JCAContext getJCAContext() {
        return this.jcaContext;
    }
}

