/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.key.command;

import com.nimbusds.jose.JWSAlgorithm;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;
import org.apache.nifi.web.security.jwt.jws.JwsSignerContainer;
import org.apache.nifi.web.security.jwt.jws.SignerListener;
import org.apache.nifi.web.security.jwt.key.Ed25519Signer;
import org.apache.nifi.web.security.jwt.key.VerificationKeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyGenerationCommand
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyGenerationCommand.class);
    private static final String KEY_ALGORITHM = "Ed25519";
    private static final JWSAlgorithm JWS_ALGORITHM = JWSAlgorithm.EdDSA;
    private final KeyPairGenerator keyPairGenerator;
    private final SignerListener signerListener;
    private final VerificationKeyListener verificationKeyListener;

    public KeyGenerationCommand(SignerListener signerListener, VerificationKeyListener verificationKeyListener) {
        this.signerListener = Objects.requireNonNull(signerListener, "Signer Listener required");
        this.verificationKeyListener = Objects.requireNonNull(verificationKeyListener, "Verification Key Listener required");
        try {
            this.keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void run() {
        KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        String keyIdentifier = UUID.randomUUID().toString();
        LOGGER.debug("Generated Key Pair [{}] Key Identifier [{}]", (Object)KEY_ALGORITHM, (Object)keyIdentifier);
        this.verificationKeyListener.onVerificationKeyGenerated(keyIdentifier, keyPair.getPublic());
        Ed25519Signer jwsSigner = new Ed25519Signer(keyPair.getPrivate());
        this.signerListener.onSignerUpdated(new JwsSignerContainer(keyIdentifier, JWS_ALGORITHM, jwsSigner));
    }
}

