/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.requests;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLengthFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ContentLengthFilter.class);
    public static final String MAX_LENGTH_INIT_PARAM = "maxContentLength";
    public static final int MAX_LENGTH_DEFAULT = 10000000;
    private int maxContentLength;
    private static final List<String> BYPASS_URI_PREFIXES = Arrays.asList("/nifi-api/data-transfer", "/nifi-api/site-to-site");

    public void init() {
        this.maxContentLength = 10000000;
        logger.debug("Filter initialized without configuration and set max content length: {}", (Object)ContentLengthFilter.formatSize(this.maxContentLength));
    }

    public void init(FilterConfig config) throws ServletException {
        int length;
        String maxLength = config.getInitParameter(MAX_LENGTH_INIT_PARAM);
        int n = length = maxLength == null ? 10000000 : Integer.parseInt(maxLength);
        if (length < 0) {
            throw new ServletException("Invalid max request length.");
        }
        this.maxContentLength = length;
        logger.debug("Filter initialized and set max content length: {}", (Object)ContentLengthFilter.formatSize(this.maxContentLength));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean willExamine;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String httpMethod = httpRequest.getMethod();
        if (!this.isSubjectToFilter(httpRequest)) {
            logger.trace("Request {} is not subject to content length checks", (Object)httpRequest.getRequestURI());
            chain.doFilter(request, response);
            return;
        }
        boolean bl = willExamine = this.maxContentLength > 0 && (httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT"));
        if (!willExamine) {
            logger.debug("No length check of request with method {} and maximum {}", (Object)httpMethod, (Object)ContentLengthFilter.formatSize(this.maxContentLength));
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        int contentLength = request.getContentLength();
        if (contentLength > this.maxContentLength) {
            httpResponse.setContentType("text/plain");
            httpResponse.getOutputStream().write(("Payload Too Large - limit is " + ContentLengthFilter.formatSize(this.maxContentLength)).getBytes());
            httpResponse.setStatus(413);
            logger.warn("Content length check rejected request with content-length {} greater than maximum {}", (Object)ContentLengthFilter.formatSize(contentLength), (Object)ContentLengthFilter.formatSize(this.maxContentLength));
        } else {
            logger.debug("Content length check allowed request with content-length {} less than maximum {}", (Object)ContentLengthFilter.formatSize(contentLength), (Object)ContentLengthFilter.formatSize(this.maxContentLength));
            chain.doFilter((ServletRequest)new LimitedContentLengthRequest(httpRequest, this.maxContentLength), response);
        }
    }

    public void destroy() {
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    private boolean isSubjectToFilter(HttpServletRequest request) {
        for (String uriPrefix : BYPASS_URI_PREFIXES) {
            if (!request.getRequestURI().startsWith(uriPrefix)) continue;
            logger.debug("Incoming request {} matches filter bypass prefix {}; content length filter is not applied", (Object)request.getRequestURI(), (Object)uriPrefix);
            return false;
        }
        return true;
    }

    private static String formatSize(int byteSize) {
        return FormatUtils.formatDataSize((double)byteSize);
    }

    private static class LimitedContentLengthRequest
    extends HttpServletRequestWrapper {
        private int maxRequestLength;

        public LimitedContentLengthRequest(HttpServletRequest request, int maxLength) {
            super(request);
            this.maxRequestLength = maxLength;
        }

        public ServletInputStream getInputStream() throws IOException {
            final ServletInputStream originalStream = super.getInputStream();
            return new ServletInputStream(){
                private int inputStreamByteCounter = 0;

                public boolean isFinished() {
                    return originalStream.isFinished();
                }

                public boolean isReady() {
                    return originalStream.isReady();
                }

                public void setReadListener(ReadListener readListener) {
                    originalStream.setReadListener(readListener);
                }

                public int read() throws IOException {
                    int read = originalStream.read();
                    if (read == -1) {
                        return read;
                    }
                    ++this.inputStreamByteCounter;
                    if (this.inputStreamByteCounter > maxRequestLength) {
                        throw new IOException(String.format("Request input stream longer than %d B.", maxRequestLength));
                    }
                    return read;
                }
            };
        }
    }
}

