/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.registration;

import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.saml2.SamlUrlPath;
import org.apache.nifi.web.security.saml2.registration.Saml2RegistrationProperty;
import org.apache.nifi.web.security.saml2.registration.StandardRegistrationBuilderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;

public class StandardRelyingPartyRegistrationRepository
implements RelyingPartyRegistrationRepository {
    static final String BASE_URL_FORMAT = "{baseUrl}%s";
    static final String LOGIN_RESPONSE_LOCATION = String.format("{baseUrl}%s", SamlUrlPath.LOGIN_RESPONSE.getPath());
    static final String SINGLE_LOGOUT_RESPONSE_SERVICE_LOCATION = String.format("{baseUrl}%s", SamlUrlPath.SINGLE_LOGOUT_RESPONSE.getPath());
    private static final String RSA_PUBLIC_KEY_ALGORITHM = "RSA";
    private static final Principal[] UNFILTERED_ISSUERS = new Principal[0];
    private static final Logger logger = LoggerFactory.getLogger(StandardRelyingPartyRegistrationRepository.class);
    private final NiFiProperties properties;
    private final SSLContext sslContext;
    private final X509ExtendedTrustManager trustManager;
    private final X509ExtendedKeyManager keyManager;
    private final RelyingPartyRegistration relyingPartyRegistration;

    public StandardRelyingPartyRegistrationRepository(NiFiProperties properties, SSLContext sslContext, X509ExtendedKeyManager keyManager, X509ExtendedTrustManager trustManager) {
        this.properties = properties;
        this.sslContext = sslContext;
        this.keyManager = keyManager;
        this.trustManager = trustManager;
        this.relyingPartyRegistration = this.getRelyingPartyRegistration();
    }

    public RelyingPartyRegistration findByRegistrationId(String registrationId) {
        return this.relyingPartyRegistration;
    }

    private RelyingPartyRegistration getRelyingPartyRegistration() {
        StandardRegistrationBuilderProvider registrationBuilderProvider = new StandardRegistrationBuilderProvider(this.properties, this.sslContext, this.trustManager);
        RelyingPartyRegistration.Builder builder = registrationBuilderProvider.getRegistrationBuilder();
        builder.registrationId(Saml2RegistrationProperty.REGISTRATION_ID.getProperty());
        String entityId = this.properties.getSamlServiceProviderEntityId();
        builder.entityId(entityId);
        builder.assertionConsumerServiceLocation(LOGIN_RESPONSE_LOCATION);
        if (this.properties.isSamlSingleLogoutEnabled()) {
            builder.singleLogoutServiceLocation(SINGLE_LOGOUT_RESPONSE_SERVICE_LOCATION);
            builder.singleLogoutServiceResponseLocation(SINGLE_LOGOUT_RESPONSE_SERVICE_LOCATION);
        }
        Collection<Saml2X509Credential> configuredCredentials = this.getCredentials();
        List<Saml2X509Credential> signingCredentials = configuredCredentials.stream().filter(Saml2X509Credential::isSigningCredential).toList();
        logger.debug("Loaded SAML2 Signing Credentials [{}]", (Object)signingCredentials.size());
        builder.signingX509Credentials(credentials -> credentials.addAll(signingCredentials));
        builder.decryptionX509Credentials(credentials -> credentials.addAll(signingCredentials));
        List<Saml2X509Credential> verificationCredentials = configuredCredentials.stream().filter(Saml2X509Credential::isVerificationCredential).toList();
        logger.debug("Loaded SAML2 Verification Credentials [{}]", (Object)verificationCredentials.size());
        builder.assertingPartyDetails(assertingPartyDetails -> assertingPartyDetails.signingAlgorithms(signingAlgorithms -> signingAlgorithms.add(this.properties.getSamlSignatureAlgorithm())).verificationX509Credentials(credentials -> credentials.addAll(verificationCredentials)).encryptionX509Credentials(credentials -> credentials.addAll(verificationCredentials)));
        return builder.build();
    }

    private Collection<Saml2X509Credential> getCredentials() {
        ArrayList<Saml2X509Credential> credentials = new ArrayList<Saml2X509Credential>();
        if (this.keyManager != null) {
            List<String> keyAliases = this.getKeyAliases();
            for (String alias : keyAliases) {
                PrivateKey privateKey = this.keyManager.getPrivateKey(alias);
                X509Certificate[] certificateChain = this.keyManager.getCertificateChain(alias);
                X509Certificate certificate = certificateChain[0];
                Saml2X509Credential credential = new Saml2X509Credential(privateKey, certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.SIGNING, Saml2X509Credential.Saml2X509CredentialType.DECRYPTION});
                credentials.add(credential);
            }
        }
        if (this.trustManager != null) {
            for (X509Certificate certificate : this.trustManager.getAcceptedIssuers()) {
                Saml2X509Credential credential = new Saml2X509Credential(certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.ENCRYPTION, Saml2X509Credential.Saml2X509CredentialType.VERIFICATION});
                credentials.add(credential);
            }
        }
        return credentials;
    }

    private List<String> getKeyAliases() {
        ArrayList<String> keyAliases = new ArrayList<String>();
        String[] serverAliases = this.keyManager.getServerAliases(RSA_PUBLIC_KEY_ALGORITHM, UNFILTERED_ISSUERS);
        if (serverAliases != null) {
            keyAliases.addAll(Arrays.asList(serverAliases));
        }
        return keyAliases;
    }
}

