/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.nifi.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanitizeContextPathFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SanitizeContextPathFilter.class);
    private String whitelistedContextPaths = "";

    public void init(FilterConfig filterConfig) throws ServletException {
        String providedWhitelist = filterConfig.getServletContext().getInitParameter("whitelistedContextPaths");
        logger.debug("SanitizeContextPathFilter received provided whitelisted context paths from NiFi properties: " + providedWhitelist);
        if (providedWhitelist != null) {
            this.whitelistedContextPaths = providedWhitelist;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.injectContextPathAttribute(request);
        filterChain.doFilter(request, response);
    }

    protected void injectContextPathAttribute(ServletRequest request) {
        String contextPath = WebUtils.sanitizeContextPath(request, this.whitelistedContextPaths, "");
        request.setAttribute("contextPath", (Object)contextPath);
        logger.debug("SanitizeContextPathFilter set contextPath: " + contextPath);
    }

    public void destroy() {
    }

    protected String getWhitelistedContextPaths() {
        return this.whitelistedContextPaths;
    }
}

