/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.UriBuilderException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.nifi.web.util.ObjectMapperResolver;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebUtils {
    private static Logger logger = LoggerFactory.getLogger(WebUtils.class);
    static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final String PROXY_CONTEXT_PATH_HTTP_HEADER = "X-ProxyContextPath";
    private static final String FORWARDED_CONTEXT_HTTP_HEADER = "X-Forwarded-Context";
    private static final String FORWARDED_PREFIX_HTTP_HEADER = "X-Forwarded-Prefix";

    private WebUtils() {
    }

    public static Client createClient(ClientConfig config) {
        return WebUtils.createClientHelper(config, null);
    }

    public static Client createClient(ClientConfig config, SSLContext ctx) {
        return WebUtils.createClientHelper(config, ctx);
    }

    private static Client createClientHelper(ClientConfig config, SSLContext ctx) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (config != null) {
            clientBuilder = clientBuilder.withConfig((Configuration)config);
        }
        if (ctx != null) {
            clientBuilder = clientBuilder.sslContext(ctx).hostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier());
        }
        clientBuilder = (ClientBuilder)((ClientBuilder)clientBuilder.register(ObjectMapperResolver.class)).register(JacksonJaxbJsonProvider.class);
        return clientBuilder.build();
    }

    public static String getResourcePath(URI uri, HttpServletRequest request, String whitelistedContextPaths) throws UriBuilderException {
        String resourcePath = uri.getPath();
        String determinedContextPath = WebUtils.determineContextPath(request);
        if (StringUtils.isNotBlank((CharSequence)(determinedContextPath = WebUtils.normalizeContextPath(determinedContextPath)))) {
            WebUtils.verifyContextPath(whitelistedContextPaths, determinedContextPath);
            resourcePath = determinedContextPath + resourcePath;
        }
        return resourcePath;
    }

    public static void verifyContextPath(String whitelistedContextPaths, String determinedContextPath) throws UriBuilderException {
        if (StringUtils.isBlank((CharSequence)determinedContextPath)) {
            return;
        }
        List<String> individualContextPaths = Arrays.asList(StringUtils.split((String)whitelistedContextPaths, (String)","));
        if (!individualContextPaths.contains(determinedContextPath)) {
            String msg = "The provided context path [" + determinedContextPath + "] was not whitelisted [" + whitelistedContextPaths + "]";
            logger.error(msg);
            throw new UriBuilderException(msg);
        }
    }

    public static String normalizeContextPath(String determinedContextPath) {
        if (StringUtils.isNotBlank((CharSequence)determinedContextPath)) {
            if (!determinedContextPath.startsWith("/")) {
                determinedContextPath = "/" + determinedContextPath;
            }
            if (determinedContextPath.endsWith("/")) {
                determinedContextPath = determinedContextPath.substring(0, determinedContextPath.length() - 1);
            }
            return determinedContextPath;
        }
        return "";
    }

    public static String sanitizeContextPath(ServletRequest request, String whitelistedContextPaths, String jspDisplayName) {
        if (StringUtils.isBlank((CharSequence)jspDisplayName)) {
            jspDisplayName = "JSP page";
        }
        String contextPath = WebUtils.normalizeContextPath(WebUtils.determineContextPath((HttpServletRequest)request));
        try {
            WebUtils.verifyContextPath(whitelistedContextPaths, contextPath);
            return contextPath;
        }
        catch (UriBuilderException e) {
            logger.error("Error determining context path on " + jspDisplayName + ": " + e.getMessage());
            return "";
        }
    }

    public static String determineContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String proxyContextPath = request.getHeader(PROXY_CONTEXT_PATH_HTTP_HEADER);
        String forwardedContext = request.getHeader(FORWARDED_CONTEXT_HTTP_HEADER);
        String prefix = request.getHeader(FORWARDED_PREFIX_HTTP_HEADER);
        logger.debug("Context path: " + contextPath);
        String determinedContextPath = "";
        if (WebUtils.anyNotBlank(proxyContextPath, forwardedContext, prefix)) {
            logger.debug(String.format("On the request, the following context paths were parsed from headers:\n\t X-ProxyContextPath: %s\n\tX-Forwarded-Context: %s\n\tX-Forwarded-Prefix: %s", proxyContextPath, forwardedContext, prefix));
            determinedContextPath = Stream.of(proxyContextPath, forwardedContext, prefix).filter(StringUtils::isNotBlank).findFirst().orElse("");
        }
        logger.debug("Determined context path: " + determinedContextPath);
        return determinedContextPath;
    }

    private static boolean anyNotBlank(String ... strings) {
        for (String s : strings) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            return true;
        }
        return false;
    }
}

