/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.common.zendesk;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Base64;
import java.util.OptionalLong;
import org.apache.nifi.common.zendesk.ZendeskAuthenticationContext;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.HttpUriBuilder;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

public class ZendeskClient {
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String BASIC_AUTH_PREFIX = "Basic ";
    private final WebClientServiceProvider webClientServiceProvider;
    private final ZendeskAuthenticationContext authenticationContext;

    public ZendeskClient(WebClientServiceProvider webClientServiceProvider, ZendeskAuthenticationContext authenticationContext) {
        this.webClientServiceProvider = webClientServiceProvider;
        this.authenticationContext = authenticationContext;
    }

    public HttpResponseEntity performPostRequest(URI uri, InputStream inputStream) throws IOException {
        return this.webClientServiceProvider.getWebClientService().post().uri(uri).header(CONTENT_TYPE_HEADER_NAME, "application/json").header(AUTHORIZATION_HEADER_NAME, this.basicAuthHeaderValue()).body(inputStream, OptionalLong.of(inputStream.available())).retrieve();
    }

    public HttpResponseEntity performGetRequest(URI uri) {
        return this.webClientServiceProvider.getWebClientService().get().uri(uri).header(AUTHORIZATION_HEADER_NAME, this.basicAuthHeaderValue()).retrieve();
    }

    public HttpUriBuilder uriBuilder(String resourcePath) {
        return this.webClientServiceProvider.getHttpUriBuilder().scheme("https").host(String.format("%s.zendesk.com", this.authenticationContext.getSubdomain())).encodedPath(resourcePath);
    }

    private String basicAuthHeaderValue() {
        String user = this.authenticationContext.getAuthenticationType().enrichUserName(this.authenticationContext.getUser());
        String userWithPassword = user + ":" + this.authenticationContext.getAuthenticationCredentials();
        return BASIC_AUTH_PREFIX + Base64.getEncoder().encodeToString(userWithPassword.getBytes());
    }
}

