/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntityRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;

public class ODataEntityRequestImpl<E extends CommonODataEntity>
extends AbstractODataRetrieveRequest<E>
implements ODataEntityRequest<E> {
    public ODataEntityRequestImpl(CommonODataClient<?> odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    public ODataRetrieveResponse<E> execute() {
        return new ODataEntityResponseImpl(this.odataClient, this.httpClient, this.doExecute());
    }

    public class ODataEntityResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private E entity;

        private ODataEntityResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.entity = null;
        }

        public E getBody() {
            if (this.entity == null) {
                try {
                    ResWrap resource = this.odataClient.getDeserializer(ODataFormat.fromString((String)this.getContentType())).toEntity(this.getRawResponse());
                    this.entity = this.odataClient.getBinder().getODataEntity(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.entity;
        }
    }
}

