/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataPropertyRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;

public class ODataPropertyRequestImpl<T extends CommonODataProperty>
extends AbstractODataRetrieveRequest<T>
implements ODataPropertyRequest<T> {
    public ODataPropertyRequestImpl(CommonODataClient<?> odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultFormat();
    }

    @Override
    public ODataRetrieveResponse<T> execute() {
        HttpResponse res = this.doExecute();
        return new ODataPropertyResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataPropertyResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private T property;

        private ODataPropertyResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.property = null;
        }

        @Override
        public T getBody() {
            if (this.property == null) {
                try {
                    ResWrap resource = this.odataClient.getDeserializer(ODataFormat.fromString((String)this.getContentType())).toProperty(this.res.getEntity().getContent());
                    this.property = this.odataClient.getBinder().getODataProperty(resource);
                }
                catch (IOException e) {
                    throw new HttpClientException((Throwable)e);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.property;
        }
    }
}

