/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.olingo.client.api.edm.xml.EnumType;
import org.apache.olingo.client.api.edm.xml.Member;
import org.apache.olingo.client.core.edm.EdmMemberImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmMember;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.edm.AbstractEdmEnumType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmEnumTypeImpl
extends AbstractEdmEnumType {
    private static final EdmPrimitiveTypeKind[] VALID_UNDERLYING_TYPES = new EdmPrimitiveTypeKind[]{EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte, EdmPrimitiveTypeKind.Int16, EdmPrimitiveTypeKind.Int32, EdmPrimitiveTypeKind.Int64};
    private final EdmPrimitiveType underlyingType;
    private final List<String> memberNames;
    private final Map<String, EdmMember> members;

    public EdmEnumTypeImpl(ODataServiceVersion version, Edm edm, FullQualifiedName fqn, EnumType xmlEnumType) {
        super(edm, fqn, xmlEnumType.isFlags());
        if (xmlEnumType.getUnderlyingType() == null) {
            this.underlyingType = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int32);
        } else {
            EdmPrimitiveTypeKind underlyingTipeKind = EdmPrimitiveTypeKind.valueOfFQN((ODataServiceVersion)version, (String)xmlEnumType.getUnderlyingType());
            if (!ArrayUtils.contains((Object[])VALID_UNDERLYING_TYPES, (Object)underlyingTipeKind)) {
                throw new EdmException("Not allowed as underlying type: " + underlyingTipeKind);
            }
            this.underlyingType = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)underlyingTipeKind);
        }
        List xmlMembers = xmlEnumType.getMembers();
        ArrayList<String> _memberNames = new ArrayList<String>();
        LinkedHashMap<String, EdmMemberImpl> _members = new LinkedHashMap<String, EdmMemberImpl>(xmlMembers.size());
        for (Member xmlMember : xmlMembers) {
            _memberNames.add(xmlMember.getName());
            _members.put(xmlMember.getName(), new EdmMemberImpl(edm, fqn, xmlMember));
        }
        this.memberNames = Collections.unmodifiableList(_memberNames);
        this.members = Collections.unmodifiableMap(_members);
    }

    public EdmPrimitiveType getUnderlyingType() {
        return this.underlyingType;
    }

    public List<String> getMemberNames() {
        return this.memberNames;
    }

    protected Collection<? extends EdmMember> getMembers() {
        return this.members.values();
    }
}

