/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.NavigationProperty;
import org.apache.olingo.client.api.edm.xml.v4.Property;
import org.apache.olingo.client.core.edm.xml.AbstractComplexType;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.ComplexTypeImpl;
import org.apache.olingo.client.core.edm.xml.v4.NavigationPropertyImpl;
import org.apache.olingo.client.core.edm.xml.v4.PropertyImpl;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

public class ComplexTypeDeserializer
extends AbstractEdmDeserializer<AbstractComplexType> {
    @Override
    protected AbstractComplexType doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        AbstractComplexType complexType;
        AbstractComplexType abstractComplexType = complexType = ODataServiceVersion.V30 == this.version ? new org.apache.olingo.client.core.edm.xml.v3.ComplexTypeImpl() : new ComplexTypeImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    complexType.setName(jp.nextTextValue());
                } else if ("Abstract".equals(jp.getCurrentName())) {
                    ((ComplexTypeImpl)complexType).setAbstractEntityType(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("BaseType".equals(jp.getCurrentName())) {
                    ((ComplexTypeImpl)complexType).setBaseType(jp.nextTextValue());
                } else if ("OpenType".equals(jp.getCurrentName())) {
                    ((ComplexTypeImpl)complexType).setOpenType(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("Property".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    if (complexType instanceof org.apache.olingo.client.core.edm.xml.v3.ComplexTypeImpl) {
                        ((org.apache.olingo.client.core.edm.xml.v3.ComplexTypeImpl)complexType).getProperties().add((org.apache.olingo.client.core.edm.xml.v3.PropertyImpl)jp.readValueAs(org.apache.olingo.client.core.edm.xml.v3.PropertyImpl.class));
                    } else {
                        ((ComplexTypeImpl)complexType).getProperties().add((Property)jp.readValueAs(PropertyImpl.class));
                    }
                } else if ("NavigationProperty".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    ((ComplexTypeImpl)complexType).getNavigationProperties().add((NavigationProperty)jp.readValueAs(NavigationPropertyImpl.class));
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    ((ComplexTypeImpl)complexType).getAnnotations().add((Annotation)jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return complexType;
    }
}

