/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.olingo.client.api.edm.xml.v4.annotation.AnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.AbstractDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.v4.annotation.PropertyValueImpl;

public class PropertyValueDeserializer
extends AbstractEdmDeserializer<PropertyValueImpl> {
    @Override
    protected PropertyValueImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        PropertyValueImpl propValue = new PropertyValueImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Property".equals(jp.getCurrentName())) {
                    propValue.setProperty(jp.nextTextValue());
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    propValue.getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                } else if (this.isAnnotationConstExprConstruct(jp)) {
                    propValue.setValue(this.parseAnnotationConstExprConstruct(jp));
                } else {
                    propValue.setValue((AnnotationExpression)jp.readValueAs(AbstractDynamicAnnotationExpression.class));
                }
            }
            jp.nextToken();
        }
        return propValue;
    }
}

