/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.data.ServiceDocumentItem;
import org.apache.olingo.client.api.serialization.CommonODataBinder;
import org.apache.olingo.client.api.v4.EdmEnabledODataClient;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataEntitySet;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataCollectionValue;
import org.apache.olingo.commons.api.domain.ODataComplexValue;
import org.apache.olingo.commons.api.domain.ODataInlineEntity;
import org.apache.olingo.commons.api.domain.ODataInlineEntitySet;
import org.apache.olingo.commons.api.domain.ODataLink;
import org.apache.olingo.commons.api.domain.ODataLinkType;
import org.apache.olingo.commons.api.domain.ODataLinked;
import org.apache.olingo.commons.api.domain.ODataOperation;
import org.apache.olingo.commons.api.domain.ODataPrimitiveValue;
import org.apache.olingo.commons.api.domain.ODataServiceDocument;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;
import org.apache.olingo.commons.core.data.EntityImpl;
import org.apache.olingo.commons.core.data.EntitySetImpl;
import org.apache.olingo.commons.core.data.LinkImpl;
import org.apache.olingo.commons.core.data.PropertyImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.serialization.ContextURLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractODataBinder
implements CommonODataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractODataBinder.class);
    protected final CommonODataClient<?> client;

    protected AbstractODataBinder(CommonODataClient<?> client) {
        this.client = client;
    }

    public ODataServiceDocument getODataServiceDocument(ServiceDocument resource) {
        ODataServiceDocument serviceDocument = new ODataServiceDocument();
        for (ServiceDocumentItem entitySet : resource.getEntitySets()) {
            serviceDocument.getEntitySets().put(entitySet.getName(), URIUtils.getURI(resource.getBaseURI(), entitySet.getUrl()));
        }
        return serviceDocument;
    }

    public EntitySet getEntitySet(CommonODataEntitySet odataEntitySet) {
        EntitySetImpl entitySet = new EntitySetImpl();
        entitySet.setCount(odataEntitySet.getCount());
        URI next = odataEntitySet.getNext();
        if (next != null) {
            entitySet.setNext(next);
        }
        for (CommonODataEntity entity : odataEntitySet.getEntities()) {
            entitySet.getEntities().add(this.getEntity(entity));
        }
        return entitySet;
    }

    protected void links(ODataLinked odataLinked, Linked linked) {
        for (ODataLink link : odataLinked.getNavigationLinks()) {
            LOG.debug("Append navigation link\n{}", (Object)link);
            linked.getNavigationLinks().add(this.getLink(link));
        }
        for (ODataLink link : odataLinked.getAssociationLinks()) {
            LOG.debug("Append association link\n{}", (Object)link);
            linked.getAssociationLinks().add(this.getLink(link));
        }
    }

    public Entity getEntity(CommonODataEntity odataEntity) {
        EntityImpl entity = new EntityImpl();
        entity.setType(odataEntity.getTypeName() == null ? null : odataEntity.getTypeName().toString());
        URI odataEditLink = odataEntity.getEditLink();
        if (odataEditLink != null) {
            LinkImpl editLink = new LinkImpl();
            editLink.setTitle(entity.getType());
            editLink.setHref(odataEditLink.toASCIIString());
            editLink.setRel("edit");
            entity.setEditLink((Link)editLink);
        }
        if (odataEntity.isReadOnly()) {
            LinkImpl selfLink = new LinkImpl();
            selfLink.setTitle(entity.getType());
            selfLink.setHref(odataEntity.getLink().toASCIIString());
            selfLink.setRel("self");
            entity.setSelfLink((Link)selfLink);
        }
        this.links((ODataLinked)odataEntity, (Linked)entity);
        for (ODataLink link : odataEntity.getMediaEditLinks()) {
            LOG.debug("Append edit-media link\n{}", (Object)link);
            entity.getMediaEditLinks().add(this.getLink(link));
        }
        if (odataEntity.isMediaEntity()) {
            entity.setMediaContentSource(odataEntity.getMediaContentSource());
            entity.setMediaContentType(odataEntity.getMediaContentType());
            entity.setMediaETag(odataEntity.getMediaETag());
        }
        for (CommonODataProperty property : odataEntity.getProperties()) {
            entity.getProperties().add(this.getProperty(property));
        }
        return entity;
    }

    public Link getLink(ODataLink link) {
        LinkImpl linkResource = new LinkImpl();
        linkResource.setRel(link.getRel());
        linkResource.setTitle(link.getName());
        linkResource.setHref(link.getLink() == null ? null : link.getLink().toASCIIString());
        linkResource.setType(link.getType().toString());
        linkResource.setMediaETag(link.getMediaETag());
        if (link instanceof ODataInlineEntity) {
            CommonODataEntity inlineEntity = ((ODataInlineEntity)link).getEntity();
            LOG.debug("Append in-line entity\n{}", (Object)inlineEntity);
            linkResource.setInlineEntity(this.getEntity(inlineEntity));
        } else if (link instanceof ODataInlineEntitySet) {
            CommonODataEntitySet InlineEntitySet = ((ODataInlineEntitySet)link).getEntitySet();
            LOG.debug("Append in-line entity set\n{}", (Object)InlineEntitySet);
            linkResource.setInlineEntitySet(this.getEntitySet(InlineEntitySet));
        }
        return linkResource;
    }

    protected Object getValue(ODataValue value) {
        if (value == null) {
            return null;
        }
        if (value.isPrimitive()) {
            return value.asPrimitive().toValue();
        }
        if (value.isComplex()) {
            ODataComplexValue _value = value.asComplex();
            ArrayList<Property> valueResource = new ArrayList<Property>();
            for (CommonODataProperty propertyValue : _value) {
                valueResource.add(this.getProperty(propertyValue));
            }
            return valueResource;
        }
        if (value.isCollection()) {
            ODataCollectionValue _value = value.asCollection();
            ArrayList<Object> valueResource = new ArrayList<Object>();
            for (ODataValue collectionValue : _value) {
                valueResource.add(this.getValue(collectionValue));
            }
            return valueResource;
        }
        return null;
    }

    protected abstract boolean add(CommonODataEntitySet var1, CommonODataEntity var2);

    public CommonODataEntitySet getODataEntitySet(ResWrap<EntitySet> resource) {
        CommonODataEntitySet entitySet;
        if (LOG.isDebugEnabled()) {
            StringWriter writer = new StringWriter();
            try {
                this.client.getSerializer(ODataFormat.JSON).write((Writer)writer, resource.getPayload());
            }
            catch (ODataSerializerException e) {
                // empty catch block
            }
            writer.flush();
            LOG.debug("EntitySet -> ODataEntitySet:\n{}", (Object)writer.toString());
        }
        URI base = resource.getContextURL() == null ? ((EntitySet)resource.getPayload()).getBaseURI() : ContextURLParser.parse((URI)resource.getContextURL()).getServiceRoot();
        URI next = ((EntitySet)resource.getPayload()).getNext();
        CommonODataEntitySet commonODataEntitySet = entitySet = next == null ? this.client.getObjectFactory().newEntitySet() : this.client.getObjectFactory().newEntitySet(URIUtils.getURI(base, next.toASCIIString()));
        if (((EntitySet)resource.getPayload()).getCount() != null) {
            entitySet.setCount(((EntitySet)resource.getPayload()).getCount().intValue());
        }
        for (Entity entityResource : ((EntitySet)resource.getPayload()).getEntities()) {
            this.add(entitySet, this.getODataEntity((ResWrap<Entity>)new ResWrap(resource.getContextURL(), resource.getMetadataETag(), (Object)entityResource)));
        }
        return entitySet;
    }

    protected void odataNavigationLinks(EdmType edmType, Linked linked, ODataLinked odataLinked, String metadataETag, URI base) {
        for (Link link : linked.getNavigationLinks()) {
            Entity inlineEntity = link.getInlineEntity();
            EntitySet inlineEntitySet = link.getInlineEntitySet();
            if (inlineEntity == null && inlineEntitySet == null) {
                EdmNavigationProperty navProp;
                ODataLinkType linkType = null;
                if (edmType instanceof EdmStructuredType && (navProp = ((EdmStructuredType)edmType).getNavigationProperty(link.getTitle())) != null) {
                    ODataLinkType oDataLinkType = linkType = navProp.isCollection() ? ODataLinkType.ENTITY_SET_NAVIGATION : ODataLinkType.ENTITY_NAVIGATION;
                }
                if (linkType == null) {
                    linkType = link.getType() == null ? ODataLinkType.ENTITY_NAVIGATION : ODataLinkType.fromString((ODataServiceVersion)this.client.getServiceVersion(), (String)link.getRel(), (String)link.getType());
                }
                odataLinked.addLink(linkType == ODataLinkType.ENTITY_NAVIGATION ? this.client.getObjectFactory().newEntityNavigationLink(link.getTitle(), URIUtils.getURI(base, link.getHref())) : this.client.getObjectFactory().newEntitySetNavigationLink(link.getTitle(), URIUtils.getURI(base, link.getHref())));
                continue;
            }
            if (inlineEntity != null) {
                odataLinked.addLink((ODataLink)new ODataInlineEntity(this.client.getServiceVersion(), URIUtils.getURI(base, link.getHref()), ODataLinkType.ENTITY_NAVIGATION, link.getTitle(), this.getODataEntity((ResWrap<Entity>)new ResWrap(inlineEntity.getBaseURI() == null ? null : inlineEntity.getBaseURI(), metadataETag, (Object)inlineEntity))));
                continue;
            }
            odataLinked.addLink((ODataLink)new ODataInlineEntitySet(this.client.getServiceVersion(), URIUtils.getURI(base, link.getHref()), ODataLinkType.ENTITY_SET_NAVIGATION, link.getTitle(), this.getODataEntitySet((ResWrap<EntitySet>)new ResWrap(inlineEntitySet.getBaseURI() == null ? null : inlineEntitySet.getBaseURI(), metadataETag, (Object)inlineEntitySet))));
        }
    }

    private EdmEntityType findEntityType(String entitySetOrSingletonOrType, EdmEntityContainer container) {
        String[] splitted;
        Object type = null;
        String firstToken = StringUtils.substringBefore((String)entitySetOrSingletonOrType, (String)"/");
        EdmEntitySet bindingTarget = container.getEntitySet(firstToken);
        if (bindingTarget == null) {
            bindingTarget = container.getSingleton(firstToken);
        }
        if (bindingTarget != null) {
            type = bindingTarget.getEntityType();
        }
        if (entitySetOrSingletonOrType.indexOf(47) != -1 && (splitted = entitySetOrSingletonOrType.split("/")).length > 1) {
            for (int i = 1; i < splitted.length && type != null; ++i) {
                EdmNavigationProperty navProp = type.getNavigationProperty(splitted[i]);
                type = navProp == null ? null : navProp.getType();
            }
        }
        return type;
    }

    private EdmType findType(String candidateTypeName, ContextURL contextURL, String metadataETag) {
        EdmEntityType type = null;
        if (this.client instanceof EdmEnabledODataClient) {
            Edm edm = ((EdmEnabledODataClient)this.client).getEdm(metadataETag);
            if (StringUtils.isNotBlank((CharSequence)candidateTypeName)) {
                type = edm.getEntityType(new FullQualifiedName(candidateTypeName));
            }
            if (type == null && contextURL != null) {
                if (contextURL.getDerivedEntity() == null) {
                    for (EdmSchema schema : edm.getSchemas()) {
                        EdmEntityType entityType;
                        EdmEntityContainer container = schema.getEntityContainer();
                        if (container == null || (entityType = this.findEntityType(contextURL.getEntitySetOrSingletonOrType(), container)) == null) continue;
                        if (contextURL.getNavOrPropertyPath() == null) {
                            type = entityType;
                            continue;
                        }
                        EdmNavigationProperty navProp = entityType.getNavigationProperty(contextURL.getNavOrPropertyPath());
                        type = navProp == null ? entityType : navProp.getType();
                    }
                    if (type == null) {
                        type = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(contextURL.getEntitySetOrSingletonOrType()).build().getType();
                    }
                } else {
                    type = edm.getEntityType(new FullQualifiedName(contextURL.getDerivedEntity()));
                }
            }
        }
        return type;
    }

    public CommonODataEntity getODataEntity(ResWrap<Entity> resource) {
        CommonODataEntity entity;
        if (LOG.isDebugEnabled()) {
            StringWriter writer = new StringWriter();
            try {
                this.client.getSerializer(ODataFormat.JSON).write((Writer)writer, resource.getPayload());
            }
            catch (ODataSerializerException e) {
                // empty catch block
            }
            writer.flush();
            LOG.debug("EntityResource -> ODataEntity:\n{}", (Object)writer.toString());
        }
        ContextURL contextURL = ContextURLParser.parse((URI)resource.getContextURL());
        URI base = resource.getContextURL() == null ? ((Entity)resource.getPayload()).getBaseURI() : contextURL.getServiceRoot();
        EdmType edmType = this.findType(((Entity)resource.getPayload()).getType(), contextURL, resource.getMetadataETag());
        FullQualifiedName typeName = null;
        if (((Entity)resource.getPayload()).getType() == null) {
            if (edmType != null) {
                typeName = edmType.getFullQualifiedName();
            }
        } else {
            typeName = new FullQualifiedName(((Entity)resource.getPayload()).getType());
        }
        CommonODataEntity commonODataEntity = entity = ((Entity)resource.getPayload()).getSelfLink() == null ? this.client.getObjectFactory().newEntity(typeName) : this.client.getObjectFactory().newEntity(typeName, URIUtils.getURI(base, ((Entity)resource.getPayload()).getSelfLink().getHref()));
        if (StringUtils.isNotBlank((CharSequence)((Entity)resource.getPayload()).getETag())) {
            entity.setETag(((Entity)resource.getPayload()).getETag());
        }
        if (((Entity)resource.getPayload()).getEditLink() != null) {
            entity.setEditLink(URIUtils.getURI(base, ((Entity)resource.getPayload()).getEditLink().getHref()));
        }
        for (Link link : ((Entity)resource.getPayload()).getAssociationLinks()) {
            entity.addLink(this.client.getObjectFactory().newAssociationLink(link.getTitle(), URIUtils.getURI(base, link.getHref())));
        }
        this.odataNavigationLinks(edmType, (Linked)resource.getPayload(), (ODataLinked)entity, resource.getMetadataETag(), base);
        for (Link link : ((Entity)resource.getPayload()).getMediaEditLinks()) {
            entity.addLink(this.client.getObjectFactory().newMediaEditLink(link.getTitle(), URIUtils.getURI(base, link.getHref())));
        }
        for (ODataOperation operation : ((Entity)resource.getPayload()).getOperations()) {
            operation.setTarget(URIUtils.getURI(base, operation.getTarget()));
            entity.getOperations().add(operation);
        }
        if (((Entity)resource.getPayload()).isMediaEntity()) {
            entity.setMediaEntity(true);
            entity.setMediaContentSource(URIUtils.getURI(base, ((Entity)resource.getPayload()).getMediaContentSource()));
            entity.setMediaContentType(((Entity)resource.getPayload()).getMediaContentType());
            entity.setMediaETag(((Entity)resource.getPayload()).getMediaETag());
        }
        for (Property property : ((Entity)resource.getPayload()).getProperties()) {
            EdmElement edmProperty;
            EdmType propertyType = null;
            if (edmType instanceof EdmEntityType && (edmProperty = ((EdmEntityType)edmType).getProperty(property.getName())) != null) {
                propertyType = edmProperty.getType();
            }
            this.add(entity, this.getODataProperty(propertyType, property));
        }
        return entity;
    }

    protected EdmTypeInfo buildTypeInfo(ContextURL contextURL, String metadataETag, String propertyName, String propertyType) {
        EdmProperty edmProperty;
        FullQualifiedName typeName = null;
        EdmType type = this.findType(null, contextURL, metadataETag);
        if (type instanceof EdmStructuredType && (edmProperty = ((EdmStructuredType)type).getStructuralProperty(propertyName)) != null) {
            typeName = edmProperty.getType().getFullQualifiedName();
        }
        if (typeName == null && type != null) {
            typeName = type.getFullQualifiedName();
        }
        return this.buildTypeInfo(typeName, propertyType);
    }

    protected EdmTypeInfo buildTypeInfo(FullQualifiedName typeName, String propertyType) {
        EdmTypeInfo typeInfo = null;
        if (typeName == null) {
            if (propertyType != null) {
                typeInfo = new EdmTypeInfo.Builder().setTypeExpression(propertyType).build();
            }
        } else {
            typeInfo = propertyType == null || propertyType.equals(EdmPrimitiveTypeKind.String.getFullQualifiedName().toString()) ? new EdmTypeInfo.Builder().setTypeExpression(typeName.toString()).build() : new EdmTypeInfo.Builder().setTypeExpression(propertyType).build();
        }
        return typeInfo;
    }

    protected abstract CommonODataProperty getODataProperty(EdmType var1, Property var2);

    protected ODataValue getODataValue(FullQualifiedName type, Valuable valuable, URI contextURL, String metadataETag) {
        ODataPrimitiveValue value = null;
        if (valuable.isGeospatial()) {
            value = this.client.getObjectFactory().newPrimitiveValueBuilder().setValue((Object)valuable.asGeospatial()).setType(type == null || EdmPrimitiveTypeKind.Geography.getFullQualifiedName().equals((Object)type) || EdmPrimitiveTypeKind.Geometry.getFullQualifiedName().equals((Object)type) ? valuable.asGeospatial().getEdmPrimitiveTypeKind() : EdmPrimitiveTypeKind.valueOfFQN((ODataServiceVersion)this.client.getServiceVersion(), (String)type.toString())).build();
        } else if (valuable.isPrimitive() || valuable.getValueType() == null) {
            if (type != null && !EdmPrimitiveTypeKind.String.getFullQualifiedName().equals((Object)type) && "Edm".equals(type.getNamespace()) && valuable.asPrimitive() instanceof String) {
                EdmPrimitiveType primitiveType = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.valueOf((String)type.getName()));
                Class returnType = primitiveType.getDefaultType().isAssignableFrom(Calendar.class) ? Timestamp.class : primitiveType.getDefaultType();
                try {
                    valuable.setValue(valuable.getValueType(), primitiveType.valueOfString(valuable.asPrimitive().toString(), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null, returnType));
                }
                catch (EdmPrimitiveTypeException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            value = this.client.getObjectFactory().newPrimitiveValueBuilder().setValue(valuable.asPrimitive()).setType(type == null || !"Edm".equals(type.getNamespace()) ? null : EdmPrimitiveTypeKind.valueOfFQN((ODataServiceVersion)this.client.getServiceVersion(), (String)type.toString())).build();
        } else if (valuable.isComplex()) {
            ODataComplexValue cValue = this.client.getObjectFactory().newComplexValue(type == null ? null : type.toString());
            if (!valuable.isNull()) {
                EdmComplexType edmType = null;
                if (this.client instanceof EdmEnabledODataClient && type != null) {
                    edmType = ((EdmEnabledODataClient)this.client).getEdm(metadataETag).getComplexType(type);
                }
                for (Property property : valuable.asComplex()) {
                    EdmElement edmProp;
                    EdmType edmPropertyType = null;
                    if (edmType != null && (edmProp = edmType.getProperty(property.getName())) != null) {
                        edmPropertyType = edmProp.getType();
                    }
                    cValue.add(this.getODataProperty(edmPropertyType, property));
                }
            }
            value = cValue;
        } else if (valuable.isCollection()) {
            value = this.client.getObjectFactory().newCollectionValue(type == null ? null : "Collection(" + type.toString() + ")");
            for (Object _value : valuable.asCollection()) {
                PropertyImpl fake = new PropertyImpl();
                fake.setValue(valuable.getValueType().getBaseType(), _value);
                value.asCollection().add(this.getODataValue(type, (Valuable)fake, contextURL, metadataETag));
            }
        }
        return value;
    }
}

