/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization.v4;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.edm.xml.v4.XMLMetadata;
import org.apache.olingo.client.api.serialization.v4.ODataDeserializer;
import org.apache.olingo.client.core.data.JSONServiceDocumentDeserializer;
import org.apache.olingo.client.core.data.XMLServiceDocumentDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.EdmxImpl;
import org.apache.olingo.client.core.edm.xml.v4.XMLMetadataImpl;
import org.apache.olingo.client.core.serialization.AbstractODataDeserializer;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.core.serialization.AtomDeserializer;
import org.apache.olingo.commons.core.serialization.JsonDeltaDeserializer;

public class ODataDeserializerImpl
extends AbstractODataDeserializer
implements ODataDeserializer {
    private final ODataFormat format;

    public ODataDeserializerImpl(ODataServiceVersion version, boolean serverMode, ODataFormat format) {
        super(version, serverMode, format);
        this.format = format;
    }

    public XMLMetadata toMetadata(InputStream input) {
        try {
            return new XMLMetadataImpl((EdmxImpl)this.getXmlMapper().readValue(input, EdmxImpl.class));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse as Edmx document", e);
        }
    }

    public ResWrap<ServiceDocument> toServiceDocument(InputStream input) throws ODataDeserializerException {
        return this.format == ODataFormat.XML ? new XMLServiceDocumentDeserializer(this.version, false).toServiceDocument(input) : new JSONServiceDocumentDeserializer(this.version, false).toServiceDocument(input);
    }

    public ResWrap<Delta> toDelta(InputStream input) throws ODataDeserializerException {
        try {
            return this.format == ODataFormat.ATOM ? new AtomDeserializer(this.version).delta(input) : new JsonDeltaDeserializer(this.version, false).toDelta(input);
        }
        catch (XMLStreamException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }
}

