/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.uri.v4;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.olingo.client.api.Configuration;
import org.apache.olingo.client.api.uri.QueryOption;
import org.apache.olingo.client.api.uri.SegmentType;
import org.apache.olingo.client.api.uri.v4.URIBuilder;
import org.apache.olingo.client.api.uri.v4.URISearch;
import org.apache.olingo.client.core.uri.AbstractURIBuilder;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

public class URIBuilderImpl
extends AbstractURIBuilder<URIBuilder>
implements URIBuilder {
    public URIBuilderImpl(ODataServiceVersion version, Configuration configuration, String serviceRoot) {
        super(version, configuration, serviceRoot);
    }

    public URIBuilder appendKeySegment(EdmEnumType enumType, String memberName) {
        return (URIBuilder)this.appendKeySegment(enumType.toUriLiteral(memberName));
    }

    public URIBuilder appendKeySegment(Map<String, Pair<EdmEnumType, String>> enumValues, Map<String, Object> segmentValues) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Pair<EdmEnumType, String>> entry : enumValues.entrySet()) {
            values.put(entry.getKey(), ((EdmEnumType)entry.getValue().getKey()).toUriLiteral((String)entry.getValue().getValue()));
        }
        values.putAll(segmentValues);
        return (URIBuilder)this.appendKeySegment(values);
    }

    @Override
    protected URIBuilder getThis() {
        return this;
    }

    @Override
    protected String noKeysWrapper() {
        return "()";
    }

    @Override
    protected char getBoundOperationSeparator() {
        return '.';
    }

    @Override
    protected String getOperationInvokeMarker() {
        return "()";
    }

    public URIBuilder appendSingletonSegment(String segmentValue) {
        this.segments.add(new AbstractURIBuilder.Segment(SegmentType.SINGLETON, segmentValue));
        return this.getThis();
    }

    public URIBuilder appendEntityIdSegment(String segmentValue) {
        this.segments.add(new AbstractURIBuilder.Segment(SegmentType.ENTITY, null));
        return (URIBuilder)this.addQueryOption(QueryOption.ID, segmentValue);
    }

    public URIBuilder appendRefSegment() {
        this.segments.add(new AbstractURIBuilder.Segment(SegmentType.REF, SegmentType.REF.getValue()));
        return this.getThis();
    }

    public URIBuilder appendCrossjoinSegment(String ... segmentValues) {
        StringBuilder segValue = new StringBuilder(SegmentType.CROSS_JOIN.getValue()).append('(').append(StringUtils.join((Object[])segmentValues, (String)",")).append(')');
        this.segments.add(new AbstractURIBuilder.Segment(SegmentType.CROSS_JOIN, segValue.toString()));
        return this.getThis();
    }

    public URIBuilder appendAllSegment() {
        this.segments.add(new AbstractURIBuilder.Segment(SegmentType.ALL, SegmentType.ALL.getValue()));
        return this.getThis();
    }

    public URIBuilder id(String idValue) {
        return (URIBuilder)this.addQueryOption(QueryOption.ID, idValue);
    }

    public URIBuilder search(URISearch search) {
        return this.search(search.build());
    }

    public URIBuilder search(String expression) {
        return (URIBuilder)this.addQueryOption(QueryOption.SEARCH, expression);
    }

    public URIBuilder count(boolean value) {
        return (URIBuilder)this.addQueryOption(QueryOption.COUNT, Boolean.toString(value));
    }

    public URIBuilder expandWithOptions(String expandItem, Map<QueryOption, Object> options) {
        LinkedHashMap<String, Object> _options = new LinkedHashMap<String, Object>();
        for (Map.Entry<QueryOption, Object> entry : options.entrySet()) {
            _options.put("$" + entry.getKey().toString(), entry.getValue());
        }
        return (URIBuilder)this.expand(expandItem + this.buildMultiKeySegment(_options, false));
    }

    public URIBuilder expandWithSelect(String expandItem, String ... selectItems) {
        return (URIBuilder)this.expand(expandItem + "($select=" + StringUtils.join((Object[])selectItems, (String)",") + ")");
    }
}

