/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.v3;

import org.apache.olingo.client.api.communication.header.HeaderName;
import org.apache.olingo.client.api.communication.header.ODataHeaders;
import org.apache.olingo.client.api.communication.request.batch.v3.BatchRequestFactory;
import org.apache.olingo.client.api.communication.request.cud.v3.CUDRequestFactory;
import org.apache.olingo.client.api.communication.request.cud.v3.UpdateType;
import org.apache.olingo.client.api.communication.request.invoke.InvokeRequestFactory;
import org.apache.olingo.client.api.communication.request.retrieve.v3.RetrieveRequestFactory;
import org.apache.olingo.client.api.serialization.v3.ODataBinder;
import org.apache.olingo.client.api.serialization.v3.ODataDeserializer;
import org.apache.olingo.client.api.serialization.v3.ODataReader;
import org.apache.olingo.client.api.uri.v3.FilterFactory;
import org.apache.olingo.client.api.uri.v3.URIBuilder;
import org.apache.olingo.client.api.v3.ODataClient;
import org.apache.olingo.client.core.AbstractODataClient;
import org.apache.olingo.client.core.communication.header.ODataHeadersImpl;
import org.apache.olingo.client.core.communication.request.batch.v3.BatchRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.cud.v3.CUDRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.invoke.v3.InvokeRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.retrieve.v3.RetrieveRequestFactoryImpl;
import org.apache.olingo.client.core.serialization.v3.ODataBinderImpl;
import org.apache.olingo.client.core.serialization.v3.ODataDeserializerImpl;
import org.apache.olingo.client.core.serialization.v3.ODataReaderImpl;
import org.apache.olingo.client.core.uri.v3.FilterFactoryImpl;
import org.apache.olingo.client.core.uri.v3.URIBuilderImpl;
import org.apache.olingo.commons.api.domain.v3.ODataObjectFactory;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataSerializer;
import org.apache.olingo.commons.core.domain.v3.ODataObjectFactoryImpl;
import org.apache.olingo.commons.core.serialization.AtomSerializer;
import org.apache.olingo.commons.core.serialization.JsonSerializer;

public class ODataClientImpl
extends AbstractODataClient<UpdateType>
implements ODataClient {
    private final FilterFactory filterFactory = new FilterFactoryImpl(this.getServiceVersion());
    private final ODataReader reader = new ODataReaderImpl(this);
    private final ODataBinder binder = new ODataBinderImpl(this);
    private final ODataObjectFactory objectFactory = new ODataObjectFactoryImpl(this.getServiceVersion());
    private final RetrieveRequestFactory retrieveReqFact = new RetrieveRequestFactoryImpl(this);
    private final CUDRequestFactory cudReqFact = new CUDRequestFactoryImpl(this);
    private final InvokeRequestFactory invokeReqFact = new InvokeRequestFactoryImpl(this);
    private final BatchRequestFactory batchReqFact = new BatchRequestFactoryImpl(this);

    public ODataServiceVersion getServiceVersion() {
        return ODataServiceVersion.V30;
    }

    public ODataHeaders newVersionHeaders() {
        ODataHeadersImpl odataHeaders = new ODataHeadersImpl();
        odataHeaders.setHeader(HeaderName.minDataServiceVersion, ODataServiceVersion.V30.toString());
        odataHeaders.setHeader(HeaderName.maxDataServiceVersion, ODataServiceVersion.V30.toString());
        odataHeaders.setHeader(HeaderName.dataServiceVersion, ODataServiceVersion.V30.toString());
        return odataHeaders;
    }

    public URIBuilder newURIBuilder(String serviceRoot) {
        return new URIBuilderImpl(this.getServiceVersion(), this.configuration, serviceRoot);
    }

    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public ODataDeserializer getDeserializer(ODataFormat format) {
        return new ODataDeserializerImpl(this.getServiceVersion(), false, format);
    }

    public ODataSerializer getSerializer(ODataFormat format) {
        return format == ODataFormat.ATOM || format == ODataFormat.XML ? new AtomSerializer(this.getServiceVersion()) : new JsonSerializer(this.getServiceVersion(), false);
    }

    public ODataReader getReader() {
        return this.reader;
    }

    public ODataBinder getBinder() {
        return this.binder;
    }

    public ODataObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public RetrieveRequestFactory getRetrieveRequestFactory() {
        return this.retrieveReqFact;
    }

    public CUDRequestFactory getCUDRequestFactory() {
        return this.cudReqFact;
    }

    public InvokeRequestFactory getInvokeRequestFactory() {
        return this.invokeReqFact;
    }

    public BatchRequestFactory getBatchRequestFactory() {
        return this.batchReqFact;
    }
}

