/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.header.HeaderName;
import org.apache.olingo.client.api.communication.header.ODataHeaders;
import org.apache.olingo.client.api.communication.request.ODataRequest;
import org.apache.olingo.client.api.communication.request.ODataStreamer;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.api.http.HttpMethod;
import org.apache.olingo.client.core.communication.request.AbstractRequest;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ODataFormat;

public abstract class AbstractODataRequest
extends AbstractRequest
implements ODataRequest {
    protected final CommonODataClient<?> odataClient;
    protected final HttpMethod method;
    protected final ODataHeaders odataHeaders;
    protected URI uri;
    protected HttpClient httpClient;
    protected HttpUriRequest request;

    protected AbstractODataRequest(CommonODataClient<?> odataClient, HttpMethod method, URI uri) {
        this.odataClient = odataClient;
        this.method = method;
        this.odataHeaders = odataClient.newVersionHeaders();
        this.uri = uri;
        this.httpClient = this.getHttpClient(method, uri);
        this.request = odataClient.getConfiguration().getHttpUriRequestFactory().create(this.method, uri);
    }

    public abstract ODataFormat getDefaultFormat();

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
        this.httpClient = this.getHttpClient(this.method, uri);
        this.request = this.odataClient.getConfiguration().getHttpUriRequestFactory().create(this.method, this.uri);
    }

    public Collection<String> getHeaderNames() {
        return this.odataHeaders.getHeaderNames();
    }

    public String getHeader(String name) {
        return this.odataHeaders.getHeader(name);
    }

    public ODataRequest setAccept(String value) {
        this.odataHeaders.setHeader(HeaderName.accept, value);
        return this;
    }

    public ODataRequest setIfMatch(String value) {
        this.odataHeaders.setHeader(HeaderName.ifMatch, value);
        return this;
    }

    public ODataRequest setIfNoneMatch(String value) {
        this.odataHeaders.setHeader(HeaderName.ifNoneMatch, value);
        return this;
    }

    public ODataRequest setPrefer(String value) {
        this.odataHeaders.setHeader(HeaderName.prefer, value);
        return this;
    }

    public ODataRequest setXHTTPMethod(String value) {
        this.odataHeaders.setHeader(HeaderName.xHttpMethod, value);
        return this;
    }

    public ODataRequest setContentType(String value) {
        this.odataHeaders.setHeader(HeaderName.contentType, value);
        return this;
    }

    public ODataRequest setSlug(String value) {
        this.odataHeaders.setHeader(HeaderName.slug, value);
        return this;
    }

    public ODataRequest addCustomHeader(String name, String value) {
        this.odataHeaders.setHeader(name, value);
        return this;
    }

    public ODataRequest addCustomHeader(HeaderName name, String value) {
        this.odataHeaders.setHeader(name, value);
        return this;
    }

    public String getAccept() {
        String acceptHead = this.odataHeaders.getHeader(HeaderName.accept);
        return StringUtils.isBlank((CharSequence)acceptHead) ? this.getDefaultFormat().getContentType(this.odataClient.getServiceVersion()).toContentTypeString() : acceptHead;
    }

    public String getIfMatch() {
        return this.odataHeaders.getHeader(HeaderName.ifMatch);
    }

    public String getIfNoneMatch() {
        return this.odataHeaders.getHeader(HeaderName.ifNoneMatch);
    }

    public String getPrefer() {
        return this.odataHeaders.getHeader(HeaderName.prefer);
    }

    public String getContentType() {
        String contentTypeHead = this.odataHeaders.getHeader(HeaderName.contentType);
        return StringUtils.isBlank((CharSequence)contentTypeHead) ? this.getDefaultFormat().getContentType(this.odataClient.getServiceVersion()).toContentTypeString() : contentTypeHead;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public ODataHeaders getHeader() {
        return this.odataHeaders;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            StringBuilder requestBuilder = new StringBuilder();
            requestBuilder.append(this.getMethod().toString()).append(' ').append(this.uri.toString()).append(' ').append("HTTP/1.1");
            baos.write(requestBuilder.toString().getBytes());
            baos.write(ODataStreamer.CRLF);
            if (StringUtils.isBlank((CharSequence)this.odataHeaders.getHeader(HeaderName.contentType))) {
                this.setContentType(this.getContentType());
            }
            if (StringUtils.isBlank((CharSequence)this.odataHeaders.getHeader(HeaderName.accept))) {
                this.setAccept(this.getAccept());
            }
            for (String name : this.getHeaderNames()) {
                String value = this.getHeader(name);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                baos.write((name + ": " + value).getBytes());
                baos.write(ODataStreamer.CRLF);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public InputStream rawExecute() {
        try {
            HttpEntity httpEntity = this.doExecute().getEntity();
            return httpEntity == null ? null : httpEntity.getContent();
        }
        catch (IOException e) {
            throw new HttpClientException((Throwable)e);
        }
        catch (RuntimeException e) {
            this.request.abort();
            throw new HttpClientException((Throwable)e);
        }
    }

    protected HttpResponse doExecute() {
        HttpResponse response;
        this.checkRequest(this.odataClient, this.request);
        if (StringUtils.isBlank((CharSequence)this.odataHeaders.getHeader(HeaderName.contentType))) {
            this.setContentType(this.getContentType());
        }
        if (StringUtils.isBlank((CharSequence)this.odataHeaders.getHeader(HeaderName.accept))) {
            this.setAccept(this.getAccept());
        }
        if (this.odataClient.getConfiguration().isKeyAsSegment()) {
            this.addCustomHeader(HeaderName.dataServiceUrlConventions.toString(), this.odataClient.newPreferences().keyAsSegment());
        }
        for (String key : this.getHeaderNames()) {
            this.request.addHeader(key, this.odataHeaders.getHeader(key));
        }
        if (LOG.isDebugEnabled()) {
            for (Header header : this.request.getAllHeaders()) {
                LOG.debug("HTTP header being sent: " + header);
            }
        }
        try {
            response = this.httpClient.execute(this.request);
        }
        catch (IOException e) {
            throw new HttpClientException((Throwable)e);
        }
        catch (RuntimeException e) {
            this.request.abort();
            throw new HttpClientException((Throwable)e);
        }
        try {
            this.checkResponse(this.odataClient, response, this.getAccept());
        }
        catch (ODataRuntimeException e) {
            this.odataClient.getConfiguration().getHttpClientFactory().close(this.httpClient);
            throw e;
        }
        return response;
    }

    public <V extends ODataResponse> V getResponseTemplate() {
        for (Class<?> clazz : this.getClass().getDeclaredClasses()) {
            if (!ODataResponse.class.isAssignableFrom(clazz)) continue;
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(this.getClass(), CommonODataClient.class, HttpClient.class, HttpResponse.class);
                constructor.setAccessible(true);
                return (V)((ODataResponse)constructor.newInstance(this, this.odataClient, this.httpClient, null));
            }
            catch (Exception e) {
                LOG.error("Error retrieving response class template instance", (Throwable)e);
            }
        }
        throw new IllegalStateException("No response class template has been found");
    }

    private HttpClient getHttpClient(HttpMethod method, URI uri) {
        HttpClient client = this.odataClient.getConfiguration().getHttpClientFactory().create(method, uri);
        if (this.odataClient.getConfiguration().isGzipCompression()) {
            client = new DecompressingHttpClient(client);
        }
        return client;
    }
}

