/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud.v3;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.cud.v3.ODataLinkCreateRequest;
import org.apache.olingo.client.api.communication.response.ODataLinkOperationResponse;
import org.apache.olingo.client.api.http.HttpMethod;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.domain.ODataLink;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;

public class ODataLinkCreateRequestImpl
extends AbstractODataBasicRequest<ODataLinkOperationResponse>
implements ODataLinkCreateRequest {
    private final ODataLink link;

    ODataLinkCreateRequestImpl(CommonODataClient<?> odataClient, URI targetURI, ODataLink link) {
        super(odataClient, HttpMethod.POST, targetURI);
        this.link = link;
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataLinkOperationResponse execute() {
        InputStream input = this.getPayload();
        ((HttpPost)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
        try {
            ODataLinkCreateResponseImpl oDataLinkCreateResponseImpl = new ODataLinkCreateResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            return oDataLinkCreateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    protected InputStream getPayload() {
        try {
            return this.odataClient.getWriter().writeLink(this.link, ODataFormat.fromString((String)this.getContentType()));
        }
        catch (ODataSerializerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private class ODataLinkCreateResponseImpl
    extends AbstractODataResponse
    implements ODataLinkOperationResponse {
        private ODataLinkCreateResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
        }
    }
}

